/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.util.FileContentType;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;

public class ClasspathFileResourceReader
implements ContentResourceReader {
    private String filename;

    public ClasspathFileResourceReader(String filename) {
        this.filename = filename;
    }

    @Override
    public byte[] readFor(HttpRequest request) {
        try {
            return ByteStreams.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream(this.filename));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getContentType() {
        return new FileContentType(this.filename).getContentType();
    }
}

