/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.google.common.collect.ImmutableMap;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResourceReader
implements ContentResourceReader {
    private static final Logger logger = LoggerFactory.getLogger(TemplateResourceReader.class);
    private static final String TEMPLATE_NAME = "template";
    private final ContentResource template;
    private final ImmutableMap<String, Object> variables;
    private final Configuration cfg;

    public TemplateResourceReader(ContentResource template, ImmutableMap<String, Object> variables) {
        this.template = template;
        this.variables = variables;
        this.cfg = new Configuration();
        this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setIncompatibleImprovements(new Version(2, 3, 20));
    }

    @Override
    public byte[] readFor(HttpRequest request) {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        String templateSource = new String(this.template.readFor(request));
        templateLoader.putTemplate(TEMPLATE_NAME, templateSource);
        this.cfg.setTemplateLoader((TemplateLoader)templateLoader);
        try {
            Template template = this.cfg.getTemplate(TEMPLATE_NAME);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            template.process(this.variables(request), (Writer)writer);
            return stream.toByteArray();
        }
        catch (ParseException e) {
            logger.info("Template is {}", (Object)templateSource);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableMap<String, Object> variables(HttpRequest request) {
        return ImmutableMap.builder().putAll(this.variables).put((Object)"req", (Object)request).build();
    }

    @Override
    public String getContentType() {
        return this.template.getContentType();
    }

    static {
        try {
            freemarker.log.Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

