/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.setting;

import com.github.dreamhead.moco.ConfigApplier;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEvent;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.Setting;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.matcher.AndRequestMatcher;
import com.github.dreamhead.moco.util.Configs;
import com.google.common.collect.ImmutableList;

public class BaseSetting
extends Setting
implements ConfigApplier<BaseSetting> {
    public BaseSetting(RequestMatcher matcher) {
        super(matcher);
    }

    public boolean match(HttpRequest request) {
        return this.matcher.match(request) && this.handler != null;
    }

    public void writeToResponse(SessionContext context) {
        this.handler.writeToResponse(context);
        this.fireCompleteEvent();
    }

    @Override
    public BaseSetting apply(MocoConfig config) {
        RequestMatcher appliedMatcher = Configs.configItem(this.matcher, config);
        if (config.isFor("uri") && this.matcher == appliedMatcher) {
            appliedMatcher = new AndRequestMatcher((Iterable<RequestMatcher>)ImmutableList.of((Object)appliedMatcher, (Object)BaseSetting.context(config.apply(""))));
        }
        BaseSetting setting = new BaseSetting(appliedMatcher);
        setting.handler = Configs.configItem(this.handler, config);
        setting.eventTriggers = Configs.configItems(this.eventTriggers, config);
        return setting;
    }

    public void fireCompleteEvent() {
        for (MocoEventTrigger eventTrigger : this.eventTriggers) {
            if (!eventTrigger.isFor(MocoEvent.COMPLETE)) continue;
            eventTrigger.fireEvent();
        }
    }
}

