/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.github.dreamhead.moco.ConfigApplier;
import com.github.dreamhead.moco.MocoConfig;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class Configs {
    public static <T extends ConfigApplier<T>> T configItem(T source, MocoConfig ... configs) {
        if (source == null) {
            return null;
        }
        Object target = source;
        for (MocoConfig config : configs) {
            target = (ConfigApplier)target.apply(config);
        }
        return target;
    }

    public static <T extends ConfigApplier> ImmutableList<T> configItems(List<T> items, MocoConfig ... configs) {
        return FluentIterable.from(items).transform(Configs.config(configs)).toList();
    }

    private static <T extends ConfigApplier<T>> Function<T, T> config(final MocoConfig ... configs) {
        return new Function<T, T>(){

            public T apply(T item) {
                return Configs.configItem(item, configs);
            }
        };
    }

    private Configs() {
    }
}

