/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;

public class FileContentType {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=UTF-8";
    private static final ImmutableMap<String, String> contentTypeMap = ImmutableMap.builder().put((Object)"png", (Object)"image/png").put((Object)"gif", (Object)"image/gif").put((Object)"jpg", (Object)"image/jpeg").put((Object)"jpeg", (Object)"image/jpeg").put((Object)"tiff", (Object)"image/tiff").put((Object)"css", (Object)"text/css").put((Object)"html", (Object)"text/html").put((Object)"txt", (Object)"text/plain").put((Object)"js", (Object)"application/x-javascript").put((Object)"json", (Object)"application/json").put((Object)"pdf", (Object)"application/pdf").put((Object)"zip", (Object)"application/zip").put((Object)"xml", (Object)"text/xml").build();
    private final String filename;

    public FileContentType(String filename) {
        this.filename = filename;
    }

    public String getContentType() {
        return this.toContentType(Files.getFileExtension((String)this.filename));
    }

    private String toContentType(String extension) {
        String contentType = (String)contentTypeMap.get((Object)extension.toLowerCase());
        return contentType != null ? contentType : DEFAULT_CONTENT_TYPE;
    }
}

