/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid;

import com.alibaba.druid.support.http.WebStatFilter;
import com.alibaba.druid.support.spring.stat.DruidStatInterceptor;
import com.github.trang.druid.properties.DruidStatProperties;
import javax.servlet.Filter;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.RegexpMethodPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={DruidStatProperties.DruidWebStatProperties.class, DruidStatProperties.DruidAopStatProperties.class})
public class DruidStatConfiguration {

    @ConditionalOnWebApplication
    public static class DruidWebStatConfiguration {
        private static final Logger log = LoggerFactory.getLogger(DruidStatConfiguration.class);

        @ConditionalOnProperty(prefix="spring.datasource.druid.web-stat", name={"enabled"}, havingValue="true")
        @Bean
        public FilterRegistrationBean filterRegistrationBean(DruidStatProperties.DruidWebStatProperties properties) {
            log.debug("druid web-stat-filter init...");
            FilterRegistrationBean registration = new FilterRegistrationBean();
            WebStatFilter filter = new WebStatFilter();
            registration.setFilter((Filter)filter);
            registration.addUrlPatterns(new String[]{properties.getUrlPatterns()});
            registration.addInitParameter("exclusions", properties.getExclusions());
            registration.addInitParameter("sessionStatEnable", Boolean.toString(properties.isSessionStatEnable()));
            if (!StringUtils.isEmpty((Object)properties.getSessionStatMaxCount())) {
                registration.addInitParameter("sessionStatMaxCount", Integer.toString(properties.getSessionStatMaxCount()));
            }
            if (!StringUtils.isEmpty((Object)properties.getPrincipalSessionName())) {
                registration.addInitParameter("principalSessionName", properties.getPrincipalSessionName());
            }
            if (!StringUtils.isEmpty((Object)properties.getPrincipalCookieName())) {
                registration.addInitParameter("principalCookieName", properties.getPrincipalCookieName());
            }
            registration.addInitParameter("profileEnable", Boolean.toString(properties.isProfileEnable()));
            return registration;
        }
    }

    @ConditionalOnClass(value={Advice.class})
    @ConditionalOnProperty(prefix="spring.datasource.druid.aop-stat", name={"enabled"}, havingValue="true")
    public static class DruidAopStatConfiguration {
        private static final Logger log = LoggerFactory.getLogger(DruidStatConfiguration.class);
        @Value(value="${spring.aop.proxy-target-class:false}")
        private boolean proxyTargetClass;

        @Bean
        public DruidStatInterceptor druidStatInterceptor() {
            return new DruidStatInterceptor();
        }

        @Bean
        public RegexpMethodPointcutAdvisor druidStatAdvisor(DruidStatProperties.DruidAopStatProperties properties, DruidStatInterceptor druidStatInterceptor) {
            return new RegexpMethodPointcutAdvisor(properties.getPatterns(), (Advice)druidStatInterceptor);
        }

        @Bean
        public DefaultAdvisorAutoProxyCreator druidStatProxyCreator() {
            log.debug("druid aop-stat init...");
            DefaultAdvisorAutoProxyCreator druidStatProxyCreator = new DefaultAdvisorAutoProxyCreator();
            druidStatProxyCreator.setProxyTargetClass(this.proxyTargetClass);
            return druidStatProxyCreator;
        }
    }
}

