/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.fl.util;

import com.github.mybatis.fl.entity.BasisInfo;
import com.github.mybatis.fl.entity.JsonResult;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class FreemarkerUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonResult createFile(BasisInfo dataModel, String templateName, String filePath) {
        JsonResult result = new JsonResult();
        OutputStreamWriter out = null;
        String fileName = dataModel.getEntityName() + FreemarkerUtil.messageStr(templateName);
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
            configuration.setClassForTemplateLoading(FreemarkerUtil.class, "/freemarker/ftl");
            configuration.setDefaultEncoding("utf-8");
            Template template = configuration.getTemplate(templateName);
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                result.setCode(-1);
                result.setMessage("\u5df2\u7ecf\u5b58\u5728" + fileName);
                JsonResult jsonResult = result;
                return jsonResult;
            }
            file.createNewFile();
            out = new FileWriter(file);
            template.process((Object)dataModel, (Writer)out);
            result.setCode(1);
            result.setMessage("\u521b\u5efa" + fileName + "\u6210\u529f");
            JsonResult jsonResult = result;
            return jsonResult;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        result.setCode(-1);
        result.setMessage("\u521b\u5efa" + fileName + "\u5931\u8d25");
        return result;
    }

    public static String messageStr(String name) {
        if (name.equals("entity.ftl")) {
            name = ".java";
        } else if (name.equals("dao.ftl")) {
            name = "Dao.java";
        } else if (name.equals("mapper.ftl")) {
            name = "Mapper.xml";
        } else if (name.equals("service.ftl")) {
            name = "Service.java";
        } else if (name.equals("serviceImpl.ftl")) {
            name = "ServiceImpl.java";
        } else if (name.equals("controller.ftl")) {
            name = "Controller.java";
        }
        return name;
    }
}

