/*
 * Decompiled with CFR 0.152.
 */
package com.github.mybatis.fl.util;

import com.github.mybatis.fl.entity.BasisInfo;
import com.github.mybatis.fl.entity.JsonResult;
import com.github.mybatis.fl.entity.PropertyInfo;
import com.github.mybatis.fl.util.FreemarkerUtil;
import java.util.List;

public class Generator {
    public static final String ENTITY = "entity";
    public static final String DAO = "dao";
    public static final String DAO_IMPL = "daoImpl";
    public static final String SERVICE = "service";
    public static final String SERVICE_IMPL = "serviceImpl";
    public static final String CONTROLLER = "controller";
    public static final String SWAGGER_CONFIG = "swaggerConfig";

    public static JsonResult createEntity(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getEntityUrl(), bi.getEntityName(), ENTITY);
        return FreemarkerUtil.createFile(bi, "entity.ftl", fileUrl);
    }

    public static JsonResult createDao(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getDaoUrl(), bi.getEntityName(), DAO);
        return FreemarkerUtil.createFile(bi, "dao.ftl", fileUrl);
    }

    public static JsonResult createDaoImpl(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getMapperUrl(), bi.getEntityName(), DAO_IMPL);
        List<PropertyInfo> list = bi.getCis();
        String agile = "";
        for (PropertyInfo propertyInfo : list) {
            agile = agile + propertyInfo.getColumn() + ", ";
        }
        agile = agile.substring(0, agile.length() - 2);
        bi.setAgile(agile);
        return FreemarkerUtil.createFile(bi, "mapper.ftl", fileUrl);
    }

    public static JsonResult createService(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getServiceUrl(), bi.getEntityName(), SERVICE);
        return FreemarkerUtil.createFile(bi, "service.ftl", fileUrl);
    }

    public static JsonResult createServiceImpl(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getServiceImplUrl(), bi.getEntityName(), SERVICE_IMPL);
        return FreemarkerUtil.createFile(bi, "serviceImpl.ftl", fileUrl);
    }

    public static JsonResult createController(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getControllerUrl(), bi.getEntityName(), CONTROLLER);
        return FreemarkerUtil.createFile(bi, "controller.ftl", fileUrl);
    }

    public static JsonResult createSwaggerConfig(String url, BasisInfo bi) {
        String fileUrl = Generator.getGeneratorFileUrl(url, bi.getSwaggerConfigUrl(), "Swagger", SWAGGER_CONFIG);
        return FreemarkerUtil.createFile(bi, "SwaggerConfig.ftl", fileUrl);
    }

    public static String getGeneratorFileUrl(String url, String packageUrl, String entityName, String type) {
        if (type.equals(ENTITY)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + ".java";
        }
        if (type.equals(DAO)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + "Dao.java";
        }
        if (type.equals(DAO_IMPL)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + "Mapper.xml";
        }
        if (type.equals(SERVICE)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + "Service.java";
        }
        if (type.equals(SERVICE_IMPL)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + "ServiceImpl.java";
        }
        if (type.equals(CONTROLLER)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + "Controller.java";
        }
        if (type.equals(SWAGGER_CONFIG)) {
            return url + Generator.pageToUrl(packageUrl) + entityName + "Config.java";
        }
        return null;
    }

    public static String pageToUrl(String url) {
        return url.replace(".", "/") + "/";
    }
}

