/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

abstract class AbstractRedisOperation
implements RedisOperation {
    private final RedisBase base;
    private final List<Slice> params;

    AbstractRedisOperation(RedisBase base, List<Slice> params) {
        this.base = base;
        this.params = params;
    }

    void doOptionalWork() {
    }

    abstract Slice response();

    RedisBase base() {
        return this.base;
    }

    List<Slice> params() {
        return this.params;
    }

    <V> V getDataFromBase(Slice key, V defaultResponse) {
        Slice data = this.base().getValue(key);
        if (data != null) {
            return (V)Utils.deserializeObject(data);
        }
        return defaultResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slice execute() {
        try {
            this.doOptionalWork();
            RedisBase redisBase = this.base;
            synchronized (redisBase) {
                return this.response();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid number of arguments when executing command [" + this.getClass().getSimpleName() + "]", e);
        }
    }
}

