/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.server.RedisClient;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.RedisBase;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;

public class RedisService
implements Runnable {
    private final ServerSocket server;
    private final Map<Integer, RedisBase> redisBases;
    private final ServiceOptions options;

    public RedisService(ServerSocket server, Map<Integer, RedisBase> redisBases, ServiceOptions options) {
        Preconditions.checkNotNull((Object)server);
        Preconditions.checkNotNull(redisBases);
        Preconditions.checkNotNull((Object)options);
        this.server = server;
        this.redisBases = redisBases;
        this.options = options;
    }

    @Override
    public void run() {
        while (!this.server.isClosed()) {
            try {
                Socket socket = this.server.accept();
                Thread t = new Thread(new RedisClient(this.redisBases, socket, this.options));
                t.start();
            }
            catch (IOException iOException) {}
        }
    }
}

