/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.server.SliceParser;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Response {
    private static final Logger LOG = LoggerFactory.getLogger(Response.class);
    private static final String LINE_SEPARATOR = "\r\n";
    public static final Slice OK = Slice.create("+OK\r\n");
    public static final Slice NULL = Slice.create("$-1\r\n");
    public static final Slice SKIP = Slice.create("Skip this submission");

    private Response() {
    }

    public static Slice bulkString(Slice slice) {
        if (slice == null) {
            return NULL;
        }
        ByteArrayDataOutput bo = ByteStreams.newDataOutput();
        bo.write(String.format("$%d%s", slice.data().length, LINE_SEPARATOR).getBytes());
        bo.write(slice.data());
        bo.write(LINE_SEPARATOR.getBytes());
        return Slice.create(bo.toByteArray());
    }

    public static Slice error(String s) {
        return Slice.create(String.format("-%s%s", s, LINE_SEPARATOR));
    }

    public static Slice integer(long v) {
        return Slice.create(String.format(":%d%s", v, LINE_SEPARATOR));
    }

    public static Slice doubleValue(double v) {
        return Slice.create(String.format(":%g%s", v, LINE_SEPARATOR));
    }

    public static Slice array(List<Slice> values) {
        ByteArrayDataOutput bo = ByteStreams.newDataOutput();
        bo.write(String.format("*%d%s", values.size(), LINE_SEPARATOR).getBytes());
        for (Slice value : values) {
            bo.write(value.data());
        }
        return Slice.create(bo.toByteArray());
    }

    public static Slice publishedMessage(Slice channel, Slice message) {
        Slice operation = SliceParser.consumeParameter("$7\r\nmessage\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel));
        slices.add(Response.bulkString(message));
        return Response.array(slices);
    }

    public static Slice subscribedToChannel(List<Slice> channels) {
        Slice operation = SliceParser.consumeParameter("$9\r\nsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        channels.forEach(channel -> slices.add(Response.bulkString(channel)));
        slices.add(Response.integer(channels.size()));
        return Response.array(slices);
    }

    public static Slice unsubscribe(Slice channel, int remainingSubscriptions) {
        Slice operation = SliceParser.consumeParameter("$11\r\nunsubscribe\r\n".getBytes());
        ArrayList<Slice> slices = new ArrayList<Slice>();
        slices.add(Response.bulkString(operation));
        slices.add(Response.bulkString(channel));
        slices.add(Response.integer(remainingSubscriptions));
        return Response.array(slices);
    }

    public static Slice clientResponse(String command, Slice response) {
        String stringResponse = response.toString().replace("\n", "").replace("\r", "");
        if (!response.equals(SKIP)) {
            LOG.debug("Received command [" + command + "] sending reply [" + stringResponse + "]");
        }
        return response;
    }
}

