/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.support.condition.ICondition;
import com.github.houbb.heaven.support.filler.IFiller;
import com.github.houbb.heaven.support.filter.IFilter;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public final class CollectionUtil {
    public static final List EMPTY_LIST = Collections.emptyList();

    private CollectionUtil() {
    }

    public static boolean isEmpty(Collection collection) {
        return null == collection || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static List<String> arrayToList(String[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return Guavas.newArrayList();
        }
        return Guavas.newArrayList(array);
    }

    public static String[] listToArray(List<String> stringList) {
        String[] strings = new String[stringList.size()];
        return stringList.toArray(strings);
    }

    public static List<String> trimCollection(Collection<String> stringList) {
        if (CollectionUtil.isEmpty(stringList)) {
            return Collections.emptyList();
        }
        List<String> resultList = Guavas.newArrayList(stringList.size());
        for (String original : stringList) {
            resultList.add(original.trim());
        }
        return resultList;
    }

    public static <T, R> Collection<R> buildCollection(Collection<T> targets, IHandler<T, R> handler) {
        if (CollectionUtil.isEmpty(targets)) {
            return Collections.emptyList();
        }
        ArrayList<R> rList = new ArrayList<R>();
        for (T t : targets) {
            R r = handler.handle(t);
            if (!ObjectUtil.isNotNull(r)) continue;
            rList.add(r);
        }
        return rList;
    }

    public static <T, R> List<R> buildCollection(T[] targets, IHandler<T, R> handler) {
        if (ArrayUtil.isEmpty(targets)) {
            return Collections.emptyList();
        }
        ArrayList<R> rList = new ArrayList<R>(targets.length);
        for (T t : targets) {
            R r = handler.handle(t);
            if (!ObjectUtil.isNotNull(r)) continue;
            rList.add(r);
        }
        return rList;
    }

    public static <T> void addArray(Collection<T> collection, T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return;
        }
        collection.addAll(Guavas.newArrayList(array));
    }

    public static <K, V> List<K> toList(Iterable<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyList();
        }
        return CollectionUtil.toList(values.iterator(), keyFunction);
    }

    public static <K, V> List<K> toList(Iterator<V> values, IHandler<? super V, K> keyFunction) {
        if (ObjectUtil.isNull(values)) {
            return Collections.emptyList();
        }
        ArrayList<K> list = new ArrayList<K>();
        while (values.hasNext()) {
            V value = values.next();
            K key = keyFunction.handle(value);
            list.add(key);
        }
        return list;
    }

    public static <E> List<E> fillList(List<E> values, IFiller<E> filler) {
        if (ObjectUtil.isNull(values)) {
            return values;
        }
        for (E e : values) {
            filler.fill(e);
        }
        return values;
    }

    public static List<String> splitByAnyBlank(String string) {
        if (StringUtil.isEmpty(string)) {
            return Collections.emptyList();
        }
        String pattern = "\\s+";
        String[] strings = string.split(pattern);
        return Guavas.newArrayList(strings);
    }

    public static <T> List<T> filterList(List<T> list, IFilter<T> filter) {
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (T t : list) {
            if (filter.filter(t)) continue;
            resultList.add(t);
        }
        return resultList;
    }

    public static <T> List<T> conditionList(List<T> list, ICondition<T> condition) {
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<T> resultList = new ArrayList<T>();
        for (T t : list) {
            if (!condition.condition(t)) continue;
            resultList.add(t);
        }
        return resultList;
    }

    public static List<String> toStringList(List<?> pathList) {
        if (CollectionUtil.isEmpty(pathList)) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>(pathList.size());
        for (Object object : pathList) {
            if (!ObjectUtil.isNotNull(object)) continue;
            stringList.add(object.toString());
        }
        return stringList;
    }

    public static <T> Optional<T> firstNotNullElem(Collection<T> list) {
        if (CollectionUtil.isEmpty(list)) {
            return Optional.empty();
        }
        for (T elem : list) {
            if (!ObjectUtil.isNotNull(elem)) continue;
            return Optional.of(elem);
        }
        return Optional.empty();
    }

    public static String join(Collection<String> stringCollection, String connector) {
        return StringUtil.join(stringCollection, connector);
    }

    public static String join(Collection<String> stringCollection) {
        return StringUtil.join(stringCollection, ",");
    }

    public static <E> void foreach(Collection<E> collection, IHandler<E, Void> handler) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        for (E e : collection) {
            handler.handle(e);
        }
    }

    public static <E> void foreachPrint(Collection<E> collection) {
        CollectionUtil.foreach(collection, new IHandler<E, Void>(){

            @Override
            public Void handle(E e) {
                System.out.println(e);
                return null;
            }
        });
    }

    public static <E> List<E> fill(int size, E elem) {
        List<E> list = Guavas.newArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(elem);
        }
        return list;
    }

    public static List<Integer> fill(int size, int initValue) {
        List<Integer> list = Guavas.newArrayList(size);
        for (int i = 0; i < size; ++i) {
            list.add(i + initValue);
        }
        return list;
    }

    public static List<Integer> fill(int size) {
        return CollectionUtil.fill(size, 0);
    }

    public static <E> E getFirst(List<E> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static <T> List<T> distinct(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T extends Comparable> List<T> distinctAndSort(Collection<T> collection) {
        List<T> list = CollectionUtil.distinct(collection);
        return CollectionUtil.sort(list);
    }

    public static <T extends Comparable> List<T> getRepeatList(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        List<Comparable> resultList = Guavas.newArrayList();
        Set<Comparable> set = Guavas.newHashSet();
        for (Comparable elem : collection) {
            if (set.contains(elem)) {
                resultList.add(elem);
            }
            set.add(elem);
        }
        return resultList;
    }

    public static <T extends Comparable> List<T> sort(List<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        Collections.sort(collection);
        return new ArrayList<T>(collection);
    }

    public static int getStartIndex(int startIndex, Collection<?> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return 0;
        }
        if (startIndex < 0 || startIndex > collection.size() - 1) {
            return 0;
        }
        return startIndex;
    }

    public static int getEndIndex(int endIndex, Collection<?> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return 0;
        }
        int maxIndex = collection.size() - 1;
        if (endIndex < 0 || endIndex > maxIndex) {
            return maxIndex;
        }
        return endIndex;
    }

    public static <E> List<E> union(Collection<E> collectionOne, Collection<E> collectionTwo) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.addAll(collectionOne);
        set.addAll(collectionTwo);
        return new ArrayList(set);
    }

    public static <E> List<E> difference(Collection<E> collectionOne, Collection<E> collectionTwo) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        set.addAll(collectionOne);
        set.removeAll(collectionTwo);
        return new ArrayList(set);
    }

    public static <E> List<E> interSection(Collection<E> collectionOne, Collection<E> collectionTwo) {
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        for (E e : collectionOne) {
            if (!collectionTwo.contains(e)) continue;
            set.add(e);
        }
        return new ArrayList(set);
    }

    public static boolean containAny(Collection<String> firstList, Collection<String> secondList) {
        if (CollectionUtil.isEmpty(firstList) || CollectionUtil.isEmpty(secondList)) {
            return false;
        }
        for (String second : secondList) {
            if (!firstList.contains(second)) continue;
            return true;
        }
        return false;
    }

    public static String getLast(List<String> resultList) {
        if (CollectionUtil.isEmpty(resultList)) {
            return "";
        }
        return resultList.get(resultList.size() - 1);
    }

    public static void setLast(List<String> resultList, String line) {
        if (resultList == null) {
            resultList = new ArrayList<String>();
        }
        if (CollectionUtil.isEmpty(resultList)) {
            resultList.add(line);
        }
        resultList.set(resultList.size() - 1, line);
    }

    public static <T> List<T> getTopK(Collection<T> collection, int size) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        int actualSize = Math.min(collection.size(), size);
        List<T> resultList = Guavas.newArrayList();
        for (T t : collection) {
            resultList.add(t);
            if (resultList.size() < actualSize) continue;
            break;
        }
        return resultList;
    }

    public static List<String> replaceAll(Collection<String> collection, String regex, String target) {
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        List<String> resultList = Guavas.newArrayList(collection.size());
        for (String s : collection) {
            String result = s.replaceAll(regex, target);
            resultList.add(result);
        }
        return resultList;
    }

    public static <E> List<E> subList(List<E> list, int offset, int limit) {
        ArgUtil.notNegative(offset, "offset");
        ArgUtil.notNegative(limit, "limit");
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        int size = list.size();
        int actualOffset = Math.min(offset, size);
        int actualLimit = Math.min(limit, size - actualOffset);
        List<E> resultList = Guavas.newArrayList(actualLimit);
        for (int i = actualOffset; i < actualOffset + actualLimit; ++i) {
            resultList.add(list.get(i));
        }
        return resultList;
    }

    public static <E> E random(List<E> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int next = ((Random)random).nextInt(list.size());
        return list.get(next);
    }

    public static <T> List<T> list() {
        return Collections.emptyList();
    }

    public static <T> List<T> list(T t) {
        return Collections.singletonList(t);
    }

    public static <T> List<T> list(T ... ts) {
        return new ArrayList<T>(Arrays.asList(ts));
    }

    public static <T> List<T> copy(List<T> list) {
        return new ArrayList<T>(list);
    }

    public static <T> T head(List<T> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T tail(List<T> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> List<T> append(List<T> list, T t) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(t);
        return list;
    }

    public static <T> List<T> reverse(List<T> list, T t) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        ArrayList<T> results = new ArrayList<T>(list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            results.add(list.get(i));
        }
        list.add(t);
        return results;
    }

    public static <T> void addAll(Collection<T> collection, Collection<T> addCollection) {
        if (CollectionUtil.isNotEmpty(addCollection)) {
            collection.addAll(addCollection);
        }
    }

    public static <T> T random(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        Iterator<T> iterator = collection.iterator();
        int limit = collection.size();
        SecureRandom random = new SecureRandom();
        int randomIndex = random.nextInt(limit);
        int countIndex = 0;
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (countIndex >= randomIndex) {
                return next;
            }
            ++countIndex;
        }
        return null;
    }

    public static <T> List<T> pageList(List<T> list, int pageNum, int pageSize) {
        int size;
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = pageNum * pageSize;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= (size = list.size())) {
            endIndex = size - 1;
        }
        return Collections.unmodifiableList(list.subList(startIndex, endIndex));
    }

    public static <T> List<T> pageList(Collection<T> collection, int pageNum, int pageSize) {
        int size;
        if (CollectionUtil.isEmpty(collection)) {
            return Collections.emptyList();
        }
        int startIndex = (pageNum - 1) * pageSize;
        int endIndex = pageNum * pageSize;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= (size = collection.size())) {
            endIndex = size - 1;
        }
        int realSize = endIndex - startIndex;
        ArrayList<T> resultList = new ArrayList<T>(realSize);
        int indexCount = 0;
        for (T obj : collection) {
            if (indexCount >= startIndex) {
                resultList.add(obj);
            }
            if (++indexCount < endIndex) continue;
            break;
        }
        return resultList;
    }
}

