/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.io;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class StreamUtil {
    private StreamUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String toString(InputStream is, String charset) {
        try (ByteArrayOutputStream boa = new ByteArrayOutputStream();){
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                boa.write(buffer, 0, len);
            }
            byte[] result = boa.toByteArray();
            String string = new String(result, charset);
            return string;
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String toString(InputStream is) {
        return StreamUtil.toString(is, "UTF-8");
    }

    public static InputStream getInputStream(String filePath) {
        InputStream inputStream;
        try {
            inputStream = new URL(filePath).openStream();
        }
        catch (MalformedURLException localMalformedURLException) {
            try {
                inputStream = new FileInputStream(filePath);
            }
            catch (Exception localException2) {
                ClassLoader localClassLoader = Thread.currentThread().getContextClassLoader();
                if (localClassLoader == null) {
                    localClassLoader = StreamUtil.class.getClassLoader();
                }
                if ((inputStream = localClassLoader.getResourceAsStream(filePath)) == null) {
                    throw new CommonRuntimeException("Could not find file: " + filePath);
                }
            }
        }
        catch (IOException localIOException1) {
            throw new CommonRuntimeException(localIOException1);
        }
        return inputStream;
    }

    public static void closeStream(Closeable closeable) {
        if (ObjectUtil.isNotNull(closeable)) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new CommonRuntimeException(e);
            }
        }
    }

    public static List<String> readAllLines(String path) {
        InputStream inputStream = StreamUtil.class.getResourceAsStream(path);
        return StreamUtil.readAllLines(inputStream, "UTF-8", true);
    }

    public static List<String> readAllLines(InputStream is) {
        return StreamUtil.readAllLines(is, "UTF-8", true);
    }

    public static List<String> readAllLines(InputStream is, String charset, boolean ignoreEmpty) {
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader e = new BufferedReader(new InputStreamReader(is, Charset.forName(charset)));
            while (e.ready()) {
                String entry = e.readLine();
                if (StringUtil.isEmpty(entry) && ignoreEmpty) continue;
                lines.add(entry);
            }
            return lines;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

