/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.http;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.ssl.SSLSocketFactoryBuilder;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public abstract class AbstractHttpDelegate {
    public String get(String url) {
        return HttpUtil.get((String)url);
    }

    public String get(String url, Map<String, Object> paramMap) {
        return HttpUtil.get((String)url, paramMap);
    }

    public String post(String url, String data) {
        return HttpUtil.post((String)url, (String)data);
    }

    public String post(String url, Map<String, Object> paramMap) {
        return HttpUtil.post((String)url, paramMap);
    }

    public String post(String url, String data, String certPath, String certPass) {
        try {
            return HttpRequest.post((String)url).setSSLSocketFactory(SSLSocketFactoryBuilder.create().setProtocol("TLSv1").setKeyManagers(this.getKeyManager(certPass, certPath, null)).setSecureRandom(new SecureRandom()).build()).body(data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String post(String url, String data, InputStream certFile, String certPass) {
        try {
            return HttpRequest.post((String)url).setSSLSocketFactory(SSLSocketFactoryBuilder.create().setProtocol("TLSv1").setKeyManagers(this.getKeyManager(certPass, null, certFile)).setSecureRandom(new SecureRandom()).build()).body(data).execute().body();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyManager[] getKeyManager(String certPass, String certPath, InputStream certFile) throws Exception {
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        if (certFile != null) {
            clientStore.load(certFile, certPass.toCharArray());
        } else {
            clientStore.load(new FileInputStream(certPath), certPass.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientStore, certPass.toCharArray());
        return kmf.getKeyManagers();
    }
}

