/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.unionpay;

import cn.hutool.core.util.StrUtil;
import com.ijpay.unionpay.UnionPayApiConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UnionPayApiConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, UnionPayApiConfig> CFG_MAP = new ConcurrentHashMap<String, UnionPayApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_key_";

    public static UnionPayApiConfig putApiConfig(UnionPayApiConfig UnionPayApiConfig2) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, UnionPayApiConfig2);
        }
        return CFG_MAP.put(UnionPayApiConfig2.getMchId(), UnionPayApiConfig2);
    }

    public static UnionPayApiConfig setThreadLocalApiConfig(UnionPayApiConfig UnionPayApiConfig2) {
        if (StrUtil.isNotEmpty((CharSequence)UnionPayApiConfig2.getMchId())) {
            UnionPayApiConfigKit.setThreadLocalMchId(UnionPayApiConfig2.getMchId());
        }
        return UnionPayApiConfigKit.putApiConfig(UnionPayApiConfig2);
    }

    public static UnionPayApiConfig removeApiConfig(UnionPayApiConfig UnionPayApiConfig2) {
        return UnionPayApiConfigKit.removeApiConfig(UnionPayApiConfig2.getMchId());
    }

    public static UnionPayApiConfig removeApiConfig(String mchId) {
        return CFG_MAP.remove(mchId);
    }

    public static void setThreadLocalMchId(String mchId) {
        if (StrUtil.isEmpty((CharSequence)mchId)) {
            mchId = CFG_MAP.get(DEFAULT_CFG_KEY).getMchId();
        }
        TL.set(mchId);
    }

    public static void removeThreadLocalMchId() {
        TL.remove();
    }

    public static String getMchId() {
        String appId = TL.get();
        if (StrUtil.isEmpty((CharSequence)appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getMchId();
        }
        return appId;
    }

    public static UnionPayApiConfig getApiConfig() {
        String appId = UnionPayApiConfigKit.getMchId();
        return UnionPayApiConfigKit.getApiConfig(appId);
    }

    public static UnionPayApiConfig getApiConfig(String appId) {
        UnionPayApiConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 UnionPayApiConfigKit.putApiConfig(UnionPayApiConfig) \u5c06 mchId \u5bf9\u5e94\u7684 UnionPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 UnionPayApiConfigKit.getUnionPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }
}

