/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.wxpay;

import com.ijpay.core.enums.PayModel;
import com.ijpay.core.enums.SignType;
import com.ijpay.core.kit.HttpKit;
import com.ijpay.core.kit.WxPayKit;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class WxPayApi {
    private static final String UNIFIED_ORDER_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String ORDER_QUERY_URL = "https://api.mch.weixin.qq.com/pay/orderquery";
    private static final String CLOSE_ORDER_URL = "https://api.mch.weixin.qq.com/pay/closeorder";
    private static final String REVERSE_URL = "https://api.mch.weixin.qq.com/secapi/pay/reverse";
    private static final String REFUND_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private static final String REFUND_QUERY_URL = "https://api.mch.weixin.qq.com/pay/refundquery";
    private static final String DOWNLOAD_BILLY_URL = "https://api.mch.weixin.qq.com/pay/downloadbill";
    private static final String DOWNLOAD_FUND_FLOW_URL = "https://api.mch.weixin.qq.com/pay/downloadfundflow";
    private static final String REPORT_URL = "https://api.mch.weixin.qq.com/payitil/report";
    private static final String SHORT_URL = "https://api.mch.weixin.qq.com/tools/shorturl";
    private static final String AUTH_CODE_TO_OPENID_URL = "https://api.mch.weixin.qq.com/tools/authcodetoopenid";
    private static final String MICRO_PAY_URL = "https://api.mch.weixin.qq.com/pay/micropay";
    private static final String TRANSFERS_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    private static final String GET_TRANSFER_INFO_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo";
    private static final String PAY_BANK_URL = "https://api.mch.weixin.qq.com/mmpaysptrans/pay_bank";
    private static final String QUERY_BANK_URL = "https://api.mch.weixin.qq.com/mmpaysptrans/query_bank";
    private static final String GET_PUBLIC_KEY_URL = "https://fraud.mch.weixin.qq.com/risk/getpublickey";
    private static final String ENTRUST_WEB_URL = "https://api.mch.weixin.qq.com/papay/entrustweb";
    private static final String PARTNER_ENTRUST_WEB_URL = "https://api.mch.weixin.qq.com/papay/partner/entrustweb";
    private static final String H5_ENTRUST_WEB_URL = "https://api.mch.weixin.qq.com/papay/h5entrustweb";
    private static final String PARTNER_H5_ENTRUST_WEB_URL = "https://api.mch.weixin.qq.com/papay/partner/h5entrustweb";
    private static final String CONTRACT_ORDER_URL = "https://api.mch.weixin.qq.com/pay/contractorder";
    private static final String QUERY_CONTRACT_URL = "https://api.mch.weixin.qq.com/papay/querycontract";
    private static final String PARTNER_QUERY_CONTRACT_URL = "https://api.mch.weixin.qq.com/papay/partner/querycontract";
    private static final String PAP_PAY_APPLY_URL = "https://api.mch.weixin.qq.com/pay/pappayapply";
    private static final String PARTNER_PAP_PAY_APPLY_URL = "https://api.mch.weixin.qq.com/pay/partner/pappayapply";
    private static final String DELETE_CONTRACT_URL = "https://api.mch.weixin.qq.com/papay/deletecontract";
    private static final String PARTNER_DELETE_CONTRACT_URL = "https://api.mch.weixin.qq.com/papay/partner/deletecontract";
    private static final String CONTRACT_BILL_URL = "https://api.mch.weixin.qq.com/papay/contractbill";
    private static final String PAP_ORDER_QUERY_URL = "https://api.mch.weixin.qq.com/pay/paporderquery";
    private static final String PARTNER_PAP_ORDER_QUERY_URL = "https://api.mch.weixin.qq.com/pay/partner/paporderquery";
    private static final String PROFIT_SHARING_URL = "https://api.mch.weixin.qq.com/secapi/pay/profitsharing";
    private static final String MULTI_PROFIT_SHARING_URL = "https://api.mch.weixin.qq.com/secapi/pay/multiprofitsharing";
    private static final String PROFIT_SHARING_QUERY_URL = "https://api.mch.weixin.qq.com/pay/profitsharingquery";
    private static final String PROFIT_SHARING_ADD_RECEIVER_URL = "https://api.mch.weixin.qq.com/pay/profitsharingaddreceiver";
    private static final String PROFIT_SHARING_REMOVE_RECEIVER_URL = "https://api.mch.weixin.qq.com/pay/profitsharingremovereceiver";
    private static final String PROFIT_SHARING_FINISH_URL = "https://api.mch.weixin.qq.com/secapi/pay/profitsharingfinish";
    private static final String PROFIT_SHARING_RETURN_URL = "https://api.mch.weixin.qq.com/secapi/pay/profitsharingreturn";
    private static final String PROFIT_SHARING_RETURN_QUERY_URL = "https://api.mch.weixin.qq.com/pay/profitsharingreturnquery";
    private static final String SEND_COUPON_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/send_coupon";
    private static final String QUERY_COUPON_STOCK_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/query_coupon_stock";
    private static final String QUERY_COUPONS_INFO_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/querycouponsinfo";
    private static final String BATCH_QUERY_COMMENT_URL = "https://api.mch.weixin.qq.com/billcommentsp/batchquerycomment";
    private static final String DEPOSIT_FACE_PAY_URL = "https://api.mch.weixin.qq.com/deposit/facepay";
    private static final String DEPOSIT_MICRO_PAY_URL = "https://api.mch.weixin.qq.com/deposit/micropay";
    private static final String DEPOSIT_ORDER_QUERY_URL = "https://api.mch.weixin.qq.com/deposit/orderquery";
    private static final String DEPOSIT_REVERSE_URL = "https://api.mch.weixin.qq.com/deposit/reverse";
    private static final String DEPOSIT_CONSUME_URL = "https://api.mch.weixin.qq.com/deposit/consume";
    private static final String DEPOSIT_REFUND_URL = "https://api.mch.weixin.qq.com/deposit/refund";
    private static final String DEPOSIT_REFUND_QUERY_URL = "https://api.mch.weixin.qq.com/deposit/refundquery";
    private static final String FACE_PAY_URL = "https://api.mch.weixin.qq.com/pay/facepay";
    private static final String FACE_PAY_QUERY_URL = "https://api.mch.weixin.qq.com/pay/facepayquery";
    private static final String FACE_PAY_REVERSE_URL = "https://api.mch.weixin.qq.com/secapi/pay/facepayreverse";
    private static final String SEND_RED_PACK_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack";
    private static final String SEND_GROUP_RED_PACK_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack";
    private static final String GET_HB_INFO_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo";
    private static final String SEND_MINI_PROGRAM_RED_PACK_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendminiprogramhb";
    private static final String GET_SING_KEY_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey";
    private static final String UNIFIED_ORDER_SANDBOX_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/unifiedorder";
    private static final String MICRO_PAY_SANDBOX_RUL = "https://api.mch.weixin.qq.com/sandboxnew/pay/micropay";
    private static final String ORDER_QUERY_SANDBOX_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/orderquery";
    private static final String REFUND_SANDBOX_URL = "https://api.mch.weixin.qq.com/sandboxnew/secapi/pay/refund";
    private static final String REFUND_QUERY_SANDBOX_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/refundquery";
    private static final String DOWNLOAD_BILL_SANDBOX_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/downloadbill";

    private WxPayApi() {
    }

    public static String getSignKey(String mch_id, String partnerKey, SignType signType) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        String nonce_str = WxPayKit.generateStr();
        map.put("mch_id", mch_id);
        map.put("nonce_str", nonce_str);
        map.put("sign", WxPayKit.createSign(map, (String)partnerKey, (SignType)signType));
        return WxPayApi.doPost(GET_SING_KEY_URL, map);
    }

    public static String pushOrder(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(UNIFIED_ORDER_SANDBOX_URL, params);
        }
        return WxPayApi.doPost(UNIFIED_ORDER_URL, params);
    }

    public static String orderQuery(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(ORDER_QUERY_SANDBOX_URL, params);
        }
        return WxPayApi.doPost(ORDER_QUERY_URL, params);
    }

    public static String closeOrder(Map<String, String> params) {
        return WxPayApi.doPost(CLOSE_ORDER_URL, params);
    }

    public static String orderReverse(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.doPostSSL(REVERSE_URL, params, certPath, certPass);
    }

    public static String orderReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.doPostSSL(REVERSE_URL, params, certFile, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, String certPath, String certPass) {
        if (isSandbox) {
            return WxPayApi.doPostSSL(REFUND_SANDBOX_URL, params, certPath, certPass);
        }
        return WxPayApi.doPostSSL(REFUND_URL, params, certPath, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, InputStream certFile, String certPass) {
        if (isSandbox) {
            return WxPayApi.doPostSSL(REFUND_SANDBOX_URL, params, certFile, certPass);
        }
        return WxPayApi.doPostSSL(REFUND_URL, params, certFile, certPass);
    }

    public static String orderRefundQuery(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(REFUND_QUERY_SANDBOX_URL, params);
        }
        return WxPayApi.doPost(REFUND_QUERY_URL, params);
    }

    public static String downloadBill(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(DOWNLOAD_BILL_SANDBOX_URL, params);
        }
        return WxPayApi.doPost(DOWNLOAD_BILLY_URL, params);
    }

    public static String orderReport(Map<String, String> params) {
        return WxPayApi.doPost(REPORT_URL, params);
    }

    public static String toShortUrl(Map<String, String> params) {
        return WxPayApi.doPost(SHORT_URL, params);
    }

    public static String authCodeToOpenid(Map<String, String> params) {
        return WxPayApi.doPost(AUTH_CODE_TO_OPENID_URL, params);
    }

    public static String micropay(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(MICRO_PAY_SANDBOX_RUL, params);
        }
        return WxPayApi.doPost(MICRO_PAY_URL, params);
    }

    public static String transfers(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(TRANSFERS_URL, params, certPath, certPassword);
    }

    public static String transfers(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(TRANSFERS_URL, params, certFile, certPassword);
    }

    public static String getTransferInfo(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(GET_TRANSFER_INFO_URL, params, certPath, certPassword);
    }

    public static String getTransferInfo(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(GET_TRANSFER_INFO_URL, params, certFile, certPassword);
    }

    public static String payBank(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PAY_BANK_URL, params, certPath, certPassword);
    }

    public static String payBank(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PAY_BANK_URL, params, certFile, certPassword);
    }

    public static String queryBank(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(QUERY_BANK_URL, params, certPath, certPassword);
    }

    public static String queryBank(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(QUERY_BANK_URL, params, certFile, certPassword);
    }

    public static String getPublicKey(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(GET_PUBLIC_KEY_URL, params, certPath, certPassword);
    }

    public static String getPublicKey(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(GET_PUBLIC_KEY_URL, params, certFile, certPassword);
    }

    public static String entrustWeb(Map<String, Object> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.doGet(ENTRUST_WEB_URL, params);
        }
        return WxPayApi.doGet(PARTNER_ENTRUST_WEB_URL, params);
    }

    public static String h5EntrustWeb(Map<String, Object> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.doGet(H5_ENTRUST_WEB_URL, params);
        }
        return WxPayApi.doGet(PARTNER_H5_ENTRUST_WEB_URL, params);
    }

    public static String contractOrder(Map<String, String> params) {
        return WxPayApi.doPost(CONTRACT_ORDER_URL, params);
    }

    public static String queryContract(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.doPost(QUERY_CONTRACT_URL, params);
        }
        return WxPayApi.doPost(PARTNER_QUERY_CONTRACT_URL, params);
    }

    public static String papPayApply(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.doPost(PAP_PAY_APPLY_URL, params);
        }
        return WxPayApi.doPost(PARTNER_PAP_PAY_APPLY_URL, params);
    }

    public static String deleteContract(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.doPost(DELETE_CONTRACT_URL, params);
        }
        return WxPayApi.doPost(PARTNER_DELETE_CONTRACT_URL, params);
    }

    public static String contractBill(Map<String, String> params) {
        return WxPayApi.doPost(CONTRACT_BILL_URL, params);
    }

    public static String papOrderQuery(Map<String, String> params, PayModel payModel) {
        if (payModel == PayModel.BUSINESS_MODEL) {
            return WxPayApi.doPost(PAP_ORDER_QUERY_URL, params);
        }
        return WxPayApi.doPost(PARTNER_PAP_ORDER_QUERY_URL, params);
    }

    public static String profitSharing(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PROFIT_SHARING_URL, params, certPath, certPassword);
    }

    public static String profitSharing(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PROFIT_SHARING_URL, params, certFile, certPassword);
    }

    public static String multiProfitSharing(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(MULTI_PROFIT_SHARING_URL, params, certPath, certPassword);
    }

    public static String multiProfitSharing(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(MULTI_PROFIT_SHARING_URL, params, certFile, certPassword);
    }

    public static String profitSharingQuery(Map<String, String> params) {
        return WxPayApi.doPost(PROFIT_SHARING_QUERY_URL, params);
    }

    public static String profitSharingAddReceiver(Map<String, String> params) {
        return WxPayApi.doPost(PROFIT_SHARING_ADD_RECEIVER_URL, params);
    }

    public static String profitSharingRemoveReceiver(Map<String, String> params) {
        return WxPayApi.doPost(PROFIT_SHARING_REMOVE_RECEIVER_URL, params);
    }

    public static String profitSharingFinish(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PROFIT_SHARING_FINISH_URL, params, certPath, certPassword);
    }

    public static String profitSharingFinish(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PROFIT_SHARING_FINISH_URL, params, certFile, certPassword);
    }

    public static String profitSharingReturn(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PROFIT_SHARING_RETURN_URL, params, certPath, certPassword);
    }

    public static String profitSharingReturn(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PROFIT_SHARING_RETURN_URL, params, certFile, certPassword);
    }

    public static String profitSharingReturnQuery(Map<String, String> params) {
        return WxPayApi.doPost(PROFIT_SHARING_RETURN_QUERY_URL, params);
    }

    public static String sendCoupon(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(SEND_COUPON_URL, params, certPath, certPassword);
    }

    public static String sendCoupon(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(SEND_COUPON_URL, params, certFile, certPassword);
    }

    public static String queryCouponStock(Map<String, String> params) {
        return WxPayApi.doPost(QUERY_COUPON_STOCK_URL, params);
    }

    public static String queryCouponsInfo(Map<String, String> params) {
        return WxPayApi.doPost(QUERY_COUPONS_INFO_URL, params);
    }

    public static String batchQueryComment(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(BATCH_QUERY_COMMENT_URL, params, certPath, certPassword);
    }

    public static String batchQueryComment(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(BATCH_QUERY_COMMENT_URL, params, certFile, certPassword);
    }

    public static String depositFacepay(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_FACE_PAY_URL, params);
    }

    public static String depositMicropay(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_MICRO_PAY_URL, params);
    }

    public static String depositOrderQuery(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_ORDER_QUERY_URL, params);
    }

    public static String depositReverse(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DEPOSIT_REVERSE_URL, params, certFile, certPassword);
    }

    public static String depositConsume(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DEPOSIT_CONSUME_URL, params, certFile, certPassword);
    }

    public static String depositRefund(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DEPOSIT_REFUND_URL, params, certFile, certPassword);
    }

    public static String depositRefundQuery(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_REFUND_QUERY_URL, params);
    }

    public static String downloadFundFlow(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(DOWNLOAD_FUND_FLOW_URL, params, certPath, certPassword);
    }

    public static String downloadFundFlow(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DOWNLOAD_FUND_FLOW_URL, params, certFile, certPassword);
    }

    public static String facePay(Map<String, String> params) {
        return WxPayApi.doPost(FACE_PAY_URL, params);
    }

    public static String facePayQuery(Map<String, String> params) {
        return WxPayApi.doPost(FACE_PAY_QUERY_URL, params);
    }

    public static String facePayReverse(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(FACE_PAY_REVERSE_URL, params, certPath, certPassword);
    }

    public static String facePayReverse(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(FACE_PAY_REVERSE_URL, params, certFile, certPassword);
    }

    public static String sendRedPack(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(SEND_RED_PACK_URL, params, certPath, certPassword);
    }

    public static String sendRedPack(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(SEND_RED_PACK_URL, params, certFile, certPassword);
    }

    public static String sendGroupRedPack(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(SEND_GROUP_RED_PACK_URL, params, certPath, certPassword);
    }

    public static String sendGroupRedPack(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(SEND_GROUP_RED_PACK_URL, params, certFile, certPassword);
    }

    public static String getHbInfo(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(GET_HB_INFO_URL, params, certPath, certPassword);
    }

    public static String getHbInfo(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(GET_HB_INFO_URL, params, certFile, certPassword);
    }

    public static String sendMiniProgramRedPack(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(SEND_MINI_PROGRAM_RED_PACK_URL, params, certPath, certPassword);
    }

    public static String sendMiniProgramRedPack(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(SEND_MINI_PROGRAM_RED_PACK_URL, params, certFile, certPassword);
    }

    public static String doGet(String url, Map<String, Object> params) {
        return HttpKit.getDelegate().get(url, params);
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpKit.getDelegate().post(url, WxPayKit.toXml(params));
    }

    public static String doPostSSL(String url, Map<String, String> params, String certPath, String certPass) {
        return HttpKit.getDelegate().post(url, WxPayKit.toXml(params), certPath, certPass);
    }

    public static String doPostSSL(String url, Map<String, String> params, InputStream certFile, String certPass) {
        return HttpKit.getDelegate().post(url, WxPayKit.toXml(params), certFile, certPass);
    }
}

