/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.HbsParserBaseListener;
import com.github.jknack.handlebars.internal.antlr.CommonToken;
import com.github.jknack.handlebars.internal.antlr.Token;
import java.util.ArrayList;
import java.util.List;

public class WhiteSpaceControl
extends HbsParserBaseListener {
    private List<CommonToken> spaces = new ArrayList<CommonToken>();
    private int pending = 0;

    @Override
    public void enterSpaces(HbsParser.SpacesContext ctx) {
        CommonToken space = (CommonToken)ctx.SPACE().getSymbol();
        this.spaces.add(space);
    }

    @Override
    public void enterNewline(HbsParser.NewlineContext ctx) {
        CommonToken newline = (CommonToken)ctx.NL().getSymbol();
        this.spaces.add(newline);
    }

    @Override
    public void exitTemplate(HbsParser.TemplateContext ctx) {
        this.trimRight();
    }

    private void trimLeft() {
        this.hideSpaces();
    }

    private void hideSpaces() {
        for (CommonToken space : this.spaces) {
            space.setChannel(1);
        }
    }

    private void trimRight() {
        if (this.pending > 0) {
            this.hideSpaces();
            --this.pending;
        }
    }

    @Override
    public void enterText(HbsParser.TextContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterBlock(HbsParser.BlockContext ctx) {
        this.trim(ctx.start, ctx.END(0).getSymbol());
    }

    @Override
    public void enterElseStmt(HbsParser.ElseStmtContext ctx) {
        this.trim(ctx.start, ctx.END().getSymbol());
    }

    @Override
    public void enterElseStmtChain(HbsParser.ElseStmtChainContext ctx) {
        this.trim(ctx.start, ctx.END().getSymbol());
    }

    @Override
    public void exitBlock(HbsParser.BlockContext ctx) {
        this.trim(ctx.END_BLOCK().getSymbol(), ctx.END(1).getSymbol());
    }

    @Override
    public void enterComment(HbsParser.CommentContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterPartial(HbsParser.PartialContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterDelimiters(HbsParser.DelimitersContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterUnless(HbsParser.UnlessContext ctx) {
        this.trim(ctx.start, ctx.END().get(0).getSymbol());
    }

    @Override
    public void enterAmpvar(HbsParser.AmpvarContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterTvar(HbsParser.TvarContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    @Override
    public void enterVar(HbsParser.VarContext ctx) {
        this.trim(ctx.start, ctx.stop);
    }

    private void trim(Token startToken, Token endToken) {
        String end;
        this.trimRight();
        String start = this.text(startToken);
        if (start.indexOf("~") > 0) {
            this.trimLeft();
        }
        if ((end = this.text(endToken)).indexOf("~") >= 0) {
            ++this.pending;
        }
        this.spaces.clear();
    }

    private String text(Token token) {
        return token.getText();
    }
}

