/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.net.SocketAddress;
import jnr.unixsocket.Native;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocket;
import jnr.unixsocket.UnixSocketAddress;

public class UnixServerSocket {
    final UnixServerSocketChannel channel;
    final int fd;

    public UnixServerSocket() throws IOException {
        this.channel = new UnixServerSocketChannel(this);
        this.fd = this.channel.getFD();
    }

    UnixServerSocket(UnixServerSocketChannel channel) {
        this.channel = channel;
        this.fd = channel.getFD();
    }

    public UnixSocket accept() throws IOException {
        return new UnixSocket(this.channel.accept());
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 128);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (!(endpoint instanceof UnixSocketAddress)) {
            throw new IOException("Invalid address");
        }
        UnixSocketAddress addr = (UnixSocketAddress)endpoint;
        if (Native.bind(this.fd, addr.getStruct(), addr.length()) < 0) {
            throw new IOException("bind failed: " + Native.getLastErrorString());
        }
        if (Native.listen(this.fd, backlog) < 0) {
            throw new IOException("listen failed: " + Native.getLastErrorString());
        }
    }
}

