/*
 * Decompiled with CFR 0.152.
 */
package com.knightliao.plugin.starter.shade.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class TarFileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDirTarGz(String SrcDirPath, String destFile) throws FileNotFoundException, IOException {
        FileOutputStream fOut = null;
        FilterOutputStream bOut = null;
        GzipCompressorOutputStream gzOut = null;
        TarArchiveOutputStream tOut = null;
        try {
            fOut = new FileOutputStream(new File(destFile));
            bOut = new BufferedOutputStream(fOut);
            gzOut = new GzipCompressorOutputStream((OutputStream)bOut);
            tOut = new TarArchiveOutputStream((OutputStream)gzOut);
            TarFileUtils.addFileToTarGz(tOut, SrcDirPath, "");
        }
        finally {
            if (tOut != null) {
                tOut.finish();
                tOut.close();
            }
            if (gzOut != null) {
                gzOut.close();
            }
            if (bOut != null) {
                bOut.close();
            }
            if (fOut != null) {
                fOut.close();
            }
        }
    }

    private static void addFileToTarGz(TarArchiveOutputStream tOut, String path, String base) throws IOException {
        File f = new File(path);
        String entryName = base + f.getName();
        TarArchiveEntry tarEntry = new TarArchiveEntry(f, entryName);
        tOut.putArchiveEntry((ArchiveEntry)tarEntry);
        if (f.isFile()) {
            IOUtils.copy((InputStream)new FileInputStream(f), (OutputStream)tOut);
            tOut.closeArchiveEntry();
        } else {
            tOut.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    System.out.println("add " + child.getName());
                    TarFileUtils.addFileToTarGz(tOut, child.getAbsolutePath(), entryName + "/");
                }
            }
        }
    }
}

