/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.BaseResult;
import weixin.popular.bean.material.Description;
import weixin.popular.bean.material.MaterialBatchgetResult;
import weixin.popular.bean.material.MaterialGetResult;
import weixin.popular.bean.material.MaterialcountResult;
import weixin.popular.bean.media.Media;
import weixin.popular.bean.media.MediaType;
import weixin.popular.bean.message.Article;
import weixin.popular.client.BytesOrJsonResponseHandler;
import weixin.popular.client.LocalHttpClient;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.StreamUtils;

public class MaterialAPI
extends BaseAPI {
    public static Media add_news(String access_token, List<Article> articles) {
        String str = JsonUtil.toJSONString(articles);
        String messageJson = "{\"articles\":" + str + "}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/material/add_news").addParameter(MaterialAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(messageJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, Media.class);
    }

    public static Media add_material(String access_token, MediaType mediaType, File media, Description description) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/material/add_material");
        FileBody bin = new FileBody(media);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addPart("media", (ContentBody)bin);
        if (description != null) {
            multipartEntityBuilder.addTextBody("description", JsonUtil.toJSONString(description));
        }
        HttpEntity reqEntity = multipartEntityBuilder.addTextBody(MaterialAPI.getATPN(), access_token).addTextBody("type", mediaType.uploadType()).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
    }

    public static Media add_material(String access_token, MediaType mediaType, InputStream inputStream, Description description) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/material/add_material");
        byte[] data = null;
        try {
            data = StreamUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addBinaryBody("media", data, ContentType.DEFAULT_BINARY, "temp." + mediaType.fileSuffix());
        if (description != null) {
            multipartEntityBuilder.addTextBody("description", JsonUtil.toJSONString(description));
        }
        HttpEntity reqEntity = multipartEntityBuilder.addTextBody(MaterialAPI.getATPN(), access_token).addTextBody("type", mediaType.uploadType()).build();
        httpPost.setEntity(reqEntity);
        return LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
    }

    public static Media add_material(String access_token, MediaType mediaType, URI uri, Description description) {
        HttpPost httpPost = new HttpPost("https://api.weixin.qq.com/cgi-bin/material/add_material");
        CloseableHttpClient tempHttpClient = HttpClients.createDefault();
        try {
            HttpEntity entity = tempHttpClient.execute(RequestBuilder.get().setUri(uri).build()).getEntity();
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().addBinaryBody("media", EntityUtils.toByteArray((HttpEntity)entity), ContentType.get((HttpEntity)entity), "temp." + mediaType.fileSuffix());
            if (description != null) {
                multipartEntityBuilder.addTextBody("description", JsonUtil.toJSONString(description));
            }
            HttpEntity reqEntity = multipartEntityBuilder.addTextBody(MaterialAPI.getATPN(), access_token).addTextBody("type", mediaType.uploadType()).build();
            httpPost.setEntity(reqEntity);
            Media media = LocalHttpClient.executeJsonResult((HttpUriRequest)httpPost, Media.class);
            return media;
        }
        catch (UnsupportedCharsetException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                tempHttpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static MaterialGetResult get_material(String access_token, String media_id) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/material/get_material").addParameter(MaterialAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity("{\"media_id\":\"" + media_id + "\"}", Charset.forName("utf-8"))).build();
        return LocalHttpClient.execute(httpUriRequest, BytesOrJsonResponseHandler.createResponseHandler(MaterialGetResult.class));
    }

    public static BaseResult del_material(String access_token, String media_id) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/material/del_material").addParameter(MaterialAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity("{\"media_id\":\"" + media_id + "\"}", Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static BaseResult update_news(String access_token, String media_id, int index, List<Article> articles) {
        String str = JsonUtil.toJSONString(articles);
        String messageJson = "{\"media_id\":\"" + media_id + "\",\"index\":" + index + ",\"articles\":" + str + "}";
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/material/update_news").addParameter(MaterialAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(messageJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, BaseResult.class);
    }

    public static MaterialcountResult get_materialcount(String access_token) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setUri("https://api.weixin.qq.com/cgi-bin/material/get_materialcount").addParameter(MaterialAPI.getATPN(), access_token).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, MaterialcountResult.class);
    }

    public static MaterialBatchgetResult batchget_material(String access_token, String type, int offset, int count) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/material/batchget_material").addParameter(MaterialAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity("{\"type\":\"" + type + "\",\"offset\":" + offset + ",\"count\":" + count + "}", Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, MaterialBatchgetResult.class);
    }
}

