/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.api;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import weixin.popular.api.BaseAPI;
import weixin.popular.bean.qrcode.QrcodeTicket;
import weixin.popular.client.LocalHttpClient;

public class QrcodeAPI
extends BaseAPI {
    private static QrcodeTicket qrcodeCreate(String access_token, String qrcodeJson) {
        HttpUriRequest httpUriRequest = RequestBuilder.post().setHeader(jsonHeader).setUri("https://api.weixin.qq.com/cgi-bin/qrcode/create").addParameter(QrcodeAPI.getATPN(), access_token).setEntity((HttpEntity)new StringEntity(qrcodeJson, Charset.forName("utf-8"))).build();
        return LocalHttpClient.executeJsonResult(httpUriRequest, QrcodeTicket.class);
    }

    public static QrcodeTicket qrcodeCreateTemp(String access_token, int expire_seconds, long scene_id) {
        String json = String.format("{\"expire_seconds\": %d, \"action_name\": \"QR_SCENE\", \"action_info\": {\"scene\": {\"scene_id\": %d}}}", expire_seconds, scene_id);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static QrcodeTicket qrcodeCreateFinal(String access_token, int scene_id) {
        String json = String.format("{\"action_name\": \"QR_LIMIT_SCENE\", \"action_info\": {\"scene\": {\"scene_id\":%d}}}", scene_id);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static QrcodeTicket qrcodeCreateFinal(String access_token, String scene_str) {
        String json = String.format("{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"%s\"}}}", scene_str);
        return QrcodeAPI.qrcodeCreate(access_token, json);
    }

    public static BufferedImage showqrcode(String ticket) {
        HttpUriRequest httpUriRequest = RequestBuilder.get().setUri("https://mp.weixin.qq.com/cgi-bin/showqrcode").addParameter("ticket", ticket).build();
        CloseableHttpResponse httpResponse = LocalHttpClient.execute(httpUriRequest);
        try {
            int status = httpResponse.getStatusLine().getStatusCode();
            if (status == 200) {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                return bufferedImage;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

