/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapUtil {
    public static Map<String, String> order(Map<String, String> map) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
        Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().toString().compareTo(o2.getKey());
            }
        });
        int i = 0;
        while (i < infoIds.size()) {
            Map.Entry item = (Map.Entry)infoIds.get(i);
            tempMap.put((String)item.getKey(), (String)item.getValue());
            ++i;
        }
        return tempMap;
    }

    public static Map<String, String> objectToMap(Object object, String ... ignore) {
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        for (Field f : MapUtil.getAllFields(object.getClass())) {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            boolean ig = false;
            if (ignore != null && ignore.length > 0) {
                String[] stringArray = ignore;
                int n = ignore.length;
                int n2 = 0;
                while (n2 < n) {
                    String i = stringArray[n2];
                    if (i.equals(f.getName())) {
                        ig = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (ig) continue;
            Object o = null;
            try {
                o = f.get(object);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            tempMap.put(f.getName(), o == null ? "" : o.toString());
        }
        return tempMap;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        if (!clazz.equals(Object.class)) {
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
            List<Field> fields2 = MapUtil.getAllFields(clazz.getSuperclass());
            if (fields2 != null) {
                fields.addAll(fields2);
            }
            return fields;
        }
        return null;
    }

    public static String mapJoin(Map<String, String> map, boolean keyLower, boolean valueUrlencode) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String key : map.keySet()) {
            if (map.get(key) == null || "".equals(map.get(key))) continue;
            try {
                String temp = key.endsWith("_") && key.length() > 1 ? key.substring(0, key.length() - 1) : key;
                stringBuilder.append(keyLower ? temp.toLowerCase() : temp).append("=").append(valueUrlencode ? URLEncoder.encode(map.get(key), "utf-8").replace("+", "%20") : map.get(key)).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

