/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import weixin.popular.bean.pay.PayJsRequest;
import weixin.popular.bean.pay.PayNativeReply;
import weixin.popular.bean.pay.PayNativeRequest;
import weixin.popular.bean.pay.PayPackage;
import weixin.popular.bean.paymch.MchPayApp;
import weixin.popular.bean.paymch.MchPayNativeReply;
import weixin.popular.bean.paymch.PapayEntrustweb;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.MapUtil;
import weixin.popular.util.SignatureUtil;
import weixin.popular.util.XMLConverUtil;

public class PayUtil {
    public static String generatePayJsRequestJson(PayPackage payPackage, String appId, String paternerKey, String paySignkey) {
        Map<String, String> mapP = MapUtil.objectToMap(payPackage, new String[0]);
        String package_ = SignatureUtil.generatePackage(mapP, paternerKey);
        PayJsRequest payJsRequest = new PayJsRequest();
        payJsRequest.setAppId(appId);
        payJsRequest.setNonceStr(UUID.randomUUID().toString());
        payJsRequest.setPackage_(package_);
        payJsRequest.setSignType("sha1");
        payJsRequest.setTimeStamp(String.valueOf(System.currentTimeMillis() / 1000L));
        Map<String, String> mapS = MapUtil.objectToMap(payJsRequest, "signType", "paySign");
        String paySign = SignatureUtil.generatePaySign(mapS, paySignkey);
        payJsRequest.setPaySign(paySign);
        return JsonUtil.toJSONString(payJsRequest);
    }

    public static String generatePayNativeRequestURL(String appid, String productid, String paySignkey) {
        PayNativeRequest payNativeRequest = new PayNativeRequest();
        payNativeRequest.setAppid(appid);
        payNativeRequest.setNoncestr(UUID.randomUUID().toString());
        payNativeRequest.setProductid(productid);
        payNativeRequest.setTimestamp(String.valueOf(System.currentTimeMillis() / 1000L));
        Map<String, String> mapS = MapUtil.objectToMap(payNativeRequest, "sign");
        String sign = SignatureUtil.generatePaySign(mapS, paySignkey);
        payNativeRequest.setSign(sign);
        Map<String, String> map = MapUtil.objectToMap(payNativeRequest, new String[0]);
        return "weixin://wxpay/bizpayurl?" + MapUtil.mapJoin(map, false, false);
    }

    public static String generatePayNativeReplyXML(PayPackage payPackage, String appId, String retCode, String retErrMsg, String paternerKey) {
        PayNativeReply payNativeReply = new PayNativeReply();
        payNativeReply.setAppid(appId);
        payNativeReply.setNoncestr(UUID.randomUUID().toString());
        payNativeReply.setRetcode(retCode);
        payNativeReply.setReterrmsg(retErrMsg);
        payNativeReply.setTimestamp(String.valueOf(System.currentTimeMillis()));
        String package_ = SignatureUtil.generatePackage(MapUtil.objectToMap(payPackage, new String[0]), paternerKey);
        payNativeReply.setPackage_(package_);
        payNativeReply.setSignmethod("sha1");
        String appSignature = SignatureUtil.generatePackage(MapUtil.objectToMap(payNativeReply, "appsignature", "signmethod"), paternerKey);
        payNativeReply.setAppsignature(appSignature);
        return XMLConverUtil.convertToXML(payNativeReply);
    }

    public static String generateMchPayJsRequestJson(String prepay_id, String appId, String key) {
        String package_ = "prepay_id=" + prepay_id;
        PayJsRequest payJsRequest = new PayJsRequest();
        payJsRequest.setAppId(appId);
        payJsRequest.setNonceStr(UUID.randomUUID().toString().replace("-", ""));
        payJsRequest.setPackage_(package_);
        payJsRequest.setSignType("MD5");
        payJsRequest.setTimeStamp(String.valueOf(System.currentTimeMillis() / 1000L));
        Map<String, String> mapS = MapUtil.objectToMap(payJsRequest, new String[0]);
        String paySign = SignatureUtil.generateSign(mapS, key);
        payJsRequest.setPaySign(paySign);
        return JsonUtil.toJSONString(payJsRequest);
    }

    public static String generateMchPayNativeRequestURL(String appid, String mch_id, String productid, String key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("appid", appid);
        map.put("mch_id", mch_id);
        map.put("time_stamp", String.valueOf(System.currentTimeMillis() / 1000L));
        map.put("nonce_str", UUID.randomUUID().toString().replace("-", ""));
        map.put("product_id", productid);
        String sign = SignatureUtil.generateSign(map, key);
        map.put("sign", sign);
        return "weixin://wxpay/bizpayurl?" + MapUtil.mapJoin(map, false, false);
    }

    public static String generateMchPayNativeReplyXML(MchPayNativeReply mchPayNativeReply, String key) {
        Map<String, String> map = MapUtil.objectToMap(mchPayNativeReply, new String[0]);
        String sign = SignatureUtil.generateSign(map, key);
        mchPayNativeReply.setSign(sign);
        return XMLConverUtil.convertToXML(mchPayNativeReply);
    }

    public static MchPayApp generateMchAppData(String prepay_id, String appId, String partnerid, String key) {
        LinkedHashMap<String, String> wx_map = new LinkedHashMap<String, String>();
        wx_map.put("appid", appId);
        wx_map.put("partnerid", partnerid);
        wx_map.put("prepayid", prepay_id);
        wx_map.put("package", "Sign=WXPay");
        wx_map.put("noncestr", UUID.randomUUID().toString().replace("-", ""));
        wx_map.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        String sign = SignatureUtil.generateSign(wx_map, key);
        MchPayApp mchPayApp = new MchPayApp();
        mchPayApp.setAppid(appId);
        mchPayApp.setPartnerid(partnerid);
        mchPayApp.setPrepayid(prepay_id);
        mchPayApp.setPackage_((String)wx_map.get("package"));
        mchPayApp.setNoncestr((String)wx_map.get("noncestr"));
        mchPayApp.setTimestamp((String)wx_map.get("timestamp"));
        mchPayApp.setSign(sign);
        return mchPayApp;
    }

    public static String generatePapayEntrustwebURL(PapayEntrustweb papayEntrustweb, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayEntrustweb, new String[0]);
        String sign = SignatureUtil.generateSign(map, key);
        map.put("sign", sign);
        String params = MapUtil.mapJoin(map, false, true);
        return "https://api.mch.weixin.qq.com/papay/entrustweb?" + params;
    }
}

