/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.MapUtil;
import weixin.popular.util.PayUtil;

public class JsUtil {
    public static final String[] ALL_JS_API_LIST = new String[]{"checkJsApi", "onMenuShareTimeline", "onMenuShareAppMessage", "onMenuShareQQ", "onMenuShareWeibo", "onMenuShareQZone", "chooseImage", "previewImage", "uploadImage", "downloadImage", "startRecord", "stopRecord", "onVoiceRecordEnd", "playVoice", "pauseVoice", "stopVoice", "onVoicePlayEnd", "uploadVoice", "downloadVoice", "translateVoice", "getNetworkType", "openLocation", "getLocation", "startSearchBeacons", "stopSearchBeacons", "onSearchBeacons", "hideOptionMenu", "showOptionMenu", "closeWindow", "hideMenuItems", "showMenuItems", "hideAllNonBaseMenuItem", "showAllNonBaseMenuItem", "scanQRCode", "openProductSpecificView", "chooseCard", "addCard", "openCard", "chooseWXPay"};

    public static String generateConfigSignature(String noncestr, String jsapi_ticket, String timestamp, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("noncestr", noncestr);
        map.put("jsapi_ticket", jsapi_ticket);
        map.put("timestamp", timestamp);
        map.put("url", url);
        Map<String, String> tmap = MapUtil.order(map);
        String str = MapUtil.mapJoin(tmap, true, false);
        return DigestUtils.shaHex((String)str);
    }

    public static String generateConfigJson(String jsapi_ticket, boolean debug, String appId, String url, String ... jsApiList) {
        long timestamp = System.currentTimeMillis() / 1000L;
        String nonceStr = UUID.randomUUID().toString();
        String signature = JsUtil.generateConfigSignature(nonceStr, jsapi_ticket, timestamp + "", url);
        return "{" + "debug:" + debug + "," + "appId:" + "'" + appId + "'" + "," + "timestamp:" + timestamp + "," + "nonceStr:" + "'" + nonceStr + "'" + "," + "signature:" + "'" + signature + "'" + "," + "jsApiList:" + JsonUtil.toJSONString(jsApiList == null ? ALL_JS_API_LIST : jsApiList) + "}";
    }

    public static String generateChooseWXPayJson(String prepay_id, String appId, String key) {
        String json = PayUtil.generateMchPayJsRequestJson(prepay_id, appId, key);
        json = json.replaceAll("\"timeStamp\"", "\"timestamp\"").replaceAll(",?\"appId\":\"[^\"]*\",?", "");
        return json;
    }
}

