/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLTextMessage;
import weixin.popular.support.ExpireKey;
import weixin.popular.support.expirekey.DefaultExpireKey;
import weixin.popular.util.SignatureUtil;
import weixin.popular.util.XMLConverUtil;

public class ReceiveServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String token = "test";
    private static ExpireKey expireKey = new DefaultExpireKey();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream inputStream = request.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        if (echostr != null) {
            this.outputStreamWrite((OutputStream)outputStream, echostr);
            return;
        }
        if (!signature.equals(SignatureUtil.generateEventMessageSignature(this.token, timestamp, nonce))) {
            System.out.println("The request signature is invalid");
            return;
        }
        if (inputStream != null) {
            EventMessage eventMessage = XMLConverUtil.convertToObject(EventMessage.class, (InputStream)inputStream);
            String key = eventMessage.getFromUserName() + "__" + eventMessage.getToUserName() + "__" + eventMessage.getMsgId() + "__" + eventMessage.getCreateTime();
            if (expireKey.exists(key)) {
                return;
            }
            expireKey.add(key);
            XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), "\u4f60\u597d");
            xmlTextMessage.outputStreamWrite((OutputStream)outputStream);
            return;
        }
        this.outputStreamWrite((OutputStream)outputStream, "");
    }

    private boolean outputStreamWrite(OutputStream outputStream, String text) {
        try {
            outputStream.write(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

