/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.example;

import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLTextMessage;
import weixin.popular.support.ExpireKey;
import weixin.popular.support.expirekey.DefaultExpireKey;
import weixin.popular.util.SignatureUtil;
import weixin.popular.util.StreamUtils;
import weixin.popular.util.XMLConverUtil;

public class ReceiveServlet2
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String appId = "";
    private String token = "test";
    private String encodingToken = "";
    private String encodingAesKey = "";
    private static ExpireKey expireKey = new DefaultExpireKey();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String key;
        ServletInputStream inputStream = request.getInputStream();
        ServletOutputStream outputStream = response.getOutputStream();
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String echostr = request.getParameter("echostr");
        String encrypt_type = request.getParameter("encrypt_type");
        String msg_signature = request.getParameter("msg_signature");
        WXBizMsgCrypt wxBizMsgCrypt = null;
        boolean isAes = "aes".equals(encrypt_type);
        if (isAes) {
            try {
                wxBizMsgCrypt = new WXBizMsgCrypt(this.encodingToken, this.encodingAesKey, this.appId);
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        }
        if (isAes && echostr != null) {
            try {
                echostr = URLDecoder.decode(echostr, "utf-8");
                String echostr_decrypt = wxBizMsgCrypt.verifyUrl(msg_signature, timestamp, nonce, echostr);
                this.outputStreamWrite((OutputStream)outputStream, echostr_decrypt);
                return;
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        } else if (echostr != null) {
            this.outputStreamWrite((OutputStream)outputStream, echostr);
            return;
        }
        EventMessage eventMessage = null;
        if (isAes) {
            try {
                String postData = StreamUtils.copyToString((InputStream)inputStream, Charset.forName("utf-8"));
                String xmlData = wxBizMsgCrypt.decryptMsg(msg_signature, timestamp, nonce, postData);
                eventMessage = XMLConverUtil.convertToObject(EventMessage.class, xmlData);
            }
            catch (AesException e) {
                e.printStackTrace();
            }
        } else {
            if (!signature.equals(SignatureUtil.generateEventMessageSignature(this.token, timestamp, nonce))) {
                System.out.println("The request signature is invalid");
                return;
            }
            if (inputStream != null) {
                eventMessage = XMLConverUtil.convertToObject(EventMessage.class, (InputStream)inputStream);
            }
        }
        if (expireKey.exists(key = eventMessage.getFromUserName() + "__" + eventMessage.getToUserName() + "__" + eventMessage.getMsgId() + "__" + eventMessage.getCreateTime())) {
            return;
        }
        expireKey.add(key);
        XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), "\u4f60\u597d");
        xmlTextMessage.outputStreamWrite((OutputStream)outputStream, wxBizMsgCrypt);
    }

    private boolean outputStreamWrite(OutputStream outputStream, String text) {
        try {
            outputStream.write(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

