/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.HTML;

class Utils {
    private static int RND = (int)System.nanoTime();

    Utils() {
    }

    public static final int rnd() {
        RND = RND * 1664525 + 1013904223;
        return RND >>> 22;
    }

    public static final int skipSpaces(String in, int start) {
        int pos;
        for (pos = start; pos < in.length() && (in.charAt(pos) == ' ' || in.charAt(pos) == '\n'); ++pos) {
        }
        return pos < in.length() ? pos : -1;
    }

    public static final int escape(StringBuilder out, char ch, int pos) {
        switch (ch) {
            case '!': 
            case '\"': 
            case '#': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '<': 
            case '>': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '}': {
                out.append(ch);
                return pos + 1;
            }
        }
        out.append('\\');
        return pos;
    }

    public static final int readUntil(StringBuilder out, String in, int start, char ... end) {
        int pos;
        for (pos = start; pos < in.length(); ++pos) {
            char ch = in.charAt(pos);
            if (ch == '\\' && pos + 1 < in.length()) {
                pos = Utils.escape(out, in.charAt(pos + 1), pos);
                continue;
            }
            boolean endReached = false;
            for (int n = 0; n < end.length; ++n) {
                if (ch != end[n]) continue;
                endReached = true;
                break;
            }
            if (endReached) break;
            out.append(ch);
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final int readUntil(StringBuilder out, String in, int start, char end) {
        int pos;
        for (pos = start; pos < in.length(); ++pos) {
            char ch = in.charAt(pos);
            if (ch == '\\' && pos + 1 < in.length()) {
                pos = Utils.escape(out, in.charAt(pos + 1), pos);
                continue;
            }
            if (ch == end) break;
            out.append(ch);
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final int readMdLink(StringBuilder out, String in, int start) {
        int pos;
        int counter = 1;
        for (pos = start; pos < in.length(); ++pos) {
            char ch = in.charAt(pos);
            if (ch == '\\' && pos + 1 < in.length()) {
                pos = Utils.escape(out, in.charAt(pos + 1), pos);
                continue;
            }
            boolean endReached = false;
            switch (ch) {
                case '(': {
                    ++counter;
                    break;
                }
                case ' ': {
                    if (counter != 1) break;
                    endReached = true;
                    break;
                }
                case ')': {
                    if (--counter != 0) break;
                    endReached = true;
                }
            }
            if (endReached) break;
            out.append(ch);
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final int readMdLinkId(StringBuilder out, String in, int start) {
        int pos;
        int counter = 1;
        for (pos = start; pos < in.length(); ++pos) {
            char ch = in.charAt(pos);
            boolean endReached = false;
            switch (ch) {
                case '\n': {
                    out.append(' ');
                    break;
                }
                case '[': {
                    ++counter;
                    out.append(ch);
                    break;
                }
                case ']': {
                    if (--counter == 0) {
                        endReached = true;
                        break;
                    }
                    out.append(ch);
                    break;
                }
                default: {
                    out.append(ch);
                }
            }
            if (endReached) break;
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final int readRawUntil(StringBuilder out, String in, int start, char ... end) {
        int pos;
        for (pos = start; pos < in.length(); ++pos) {
            char ch = in.charAt(pos);
            boolean endReached = false;
            for (int n = 0; n < end.length; ++n) {
                if (ch != end[n]) continue;
                endReached = true;
                break;
            }
            if (endReached) break;
            out.append(ch);
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final int readRawUntil(StringBuilder out, String in, int start, char end) {
        char ch;
        int pos;
        for (pos = start; pos < in.length() && (ch = in.charAt(pos)) != end; ++pos) {
            out.append(ch);
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final int readXMLUntil(StringBuilder out, String in, int start, char ... end) {
        int pos = start;
        boolean inString = false;
        char stringChar = '\u0000';
        while (pos < in.length()) {
            char ch = in.charAt(pos);
            if (inString) {
                if (ch == '\\') {
                    out.append(ch);
                    if (++pos >= in.length()) continue;
                    out.append(ch);
                    ++pos;
                    continue;
                }
                if (ch == stringChar) {
                    inString = false;
                    out.append(ch);
                    ++pos;
                    continue;
                }
            }
            switch (ch) {
                case '\"': 
                case '\'': {
                    inString = true;
                    stringChar = ch;
                }
            }
            if (!inString) {
                boolean endReached = false;
                for (int n = 0; n < end.length; ++n) {
                    if (ch != end[n]) continue;
                    endReached = true;
                    break;
                }
                if (endReached) break;
            }
            out.append(ch);
            ++pos;
        }
        return pos == in.length() ? -1 : pos;
    }

    public static final void appendCode(StringBuilder out, String in, int start, int end) {
        block5: for (int i = start; i < end; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block5;
                }
                case '<': {
                    out.append("&lt;");
                    continue block5;
                }
                case '>': {
                    out.append("&gt;");
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static final void appendValue(StringBuilder out, String in, int start, int end) {
        block7: for (int i = start; i < end; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    out.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    out.append("&apos;");
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static final void appendDecEntity(StringBuilder out, char value) {
        out.append("&#");
        out.append((int)value);
        out.append(';');
    }

    public static final void appendHexEntity(StringBuilder out, char value) {
        out.append("&#x");
        out.append(Integer.toHexString(value));
        out.append(';');
    }

    public static final void appendMailto(StringBuilder out, String in, int start, int end) {
        block3: for (int i = start; i < end; ++i) {
            int r = Utils.rnd();
            char c = in.charAt(i);
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '@': {
                    if (r < 512) {
                        Utils.appendDecEntity(out, c);
                        continue block3;
                    }
                    Utils.appendHexEntity(out, c);
                    continue block3;
                }
                default: {
                    if (r < 32) {
                        out.append(c);
                        continue block3;
                    }
                    if (r < 520) {
                        Utils.appendDecEntity(out, c);
                        continue block3;
                    }
                    Utils.appendHexEntity(out, c);
                }
            }
        }
    }

    public static final void getXMLTag(StringBuilder out, StringBuilder in) {
        int pos = 1;
        if (in.charAt(1) == '/') {
            ++pos;
        }
        while (Character.isLetterOrDigit(in.charAt(pos))) {
            out.append(in.charAt(pos++));
        }
    }

    public static final void getXMLTag(StringBuilder out, String in) {
        int pos = 1;
        if (in.charAt(1) == '/') {
            ++pos;
        }
        while (Character.isLetterOrDigit(in.charAt(pos))) {
            out.append(in.charAt(pos++));
        }
    }

    public static final int readXML(StringBuilder out, String in, int start, boolean safeMode) {
        try {
            int pos;
            boolean isCloseTag;
            if (in.charAt(start + 1) == '/') {
                isCloseTag = true;
                pos = start + 2;
            } else {
                if (in.charAt(start + 1) == '!') {
                    out.append("<!");
                    return start + 1;
                }
                isCloseTag = false;
                pos = start + 1;
            }
            if (safeMode) {
                StringBuilder temp = new StringBuilder();
                if ((pos = Utils.readXMLUntil(temp, in, pos, ' ', '/', '>')) == -1) {
                    return -1;
                }
                String tag = temp.toString().trim().toLowerCase();
                if (HTML.isUnsafeHtmlElement(tag)) {
                    out.append("&lt;");
                } else {
                    out.append("<");
                }
                if (isCloseTag) {
                    out.append('/');
                }
                out.append((CharSequence)temp);
            } else {
                out.append('<');
                if (isCloseTag) {
                    out.append('/');
                }
                pos = Utils.readXMLUntil(out, in, pos, ' ', '/', '>');
            }
            if (pos == -1) {
                return -1;
            }
            if (in.charAt(pos = Utils.readXMLUntil(out, in, pos, '/', '>')) == '/') {
                out.append(" /");
                pos = Utils.readXMLUntil(out, in, pos + 1, '>');
                if (pos == -1) {
                    return -1;
                }
            }
            if (in.charAt(pos) == '>') {
                out.append('>');
                return pos;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
        return -1;
    }

    public static final void codeEncode(StringBuilder out, String value, int offset) {
        block5: for (int i = offset; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block5;
                }
                case '<': {
                    out.append("&lt;");
                    continue block5;
                }
                case '>': {
                    out.append("&gt;");
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    public static final String getMetaFromFence(String fenceLine) {
        for (int i = 0; i < fenceLine.length(); ++i) {
            char c = fenceLine.charAt(i);
            if (Character.isWhitespace(c) || c == '`' || c == '~') continue;
            return fenceLine.substring(i).trim();
        }
        return "";
    }
}

