/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.domain.proto.storage;

import com.github.tobato.fastdfs.domain.proto.storage.DownloadCallback;
import com.github.tobato.fastdfs.exception.FdfsIOException;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFileWriter
implements DownloadCallback<String> {
    protected static Logger LOGGER = LoggerFactory.getLogger(DownloadFileWriter.class);
    private String fileName;

    public DownloadFileWriter(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String recv(InputStream ins) throws IOException {
        FileOutputStream out = null;
        BufferedInputStream in = null;
        try {
            out = new FileOutputStream(this.fileName);
            in = new BufferedInputStream(ins);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            try {
                LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u63a5\u6536\u5904\u7406\u5931\u8d25", e.getCause());
                throw new FdfsIOException("\u6587\u4ef6\u4e0b\u8f7d\u63a5\u6536\u5904\u7406\u5931\u8d25");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly((OutputStream)out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        return this.fileName;
    }
}

