/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wiremock.org.xmlunit.diff.DefaultConditionalSelectorBuilder;
import wiremock.org.xmlunit.diff.DefaultNodeMatcher;
import wiremock.org.xmlunit.diff.ElementSelector;
import wiremock.org.xmlunit.diff.XPathContext;
import wiremock.org.xmlunit.util.IsNullPredicate;
import wiremock.org.xmlunit.util.Linqy;
import wiremock.org.xmlunit.util.Mapper;
import wiremock.org.xmlunit.util.Nodes;
import wiremock.org.xmlunit.util.Predicate;
import wiremock.org.xmlunit.xpath.JAXPXPathEngine;

public final class ElementSelectors {
    public static final ElementSelector Default = new ElementSelector(){

        @Override
        public boolean canBeCompared(Element controlElement, Element testElement) {
            return true;
        }
    };
    public static final ElementSelector byName = new ElementSelector(){

        @Override
        public boolean canBeCompared(Element controlElement, Element testElement) {
            return controlElement != null && testElement != null && ElementSelectors.bothNullOrEqual(Nodes.getQName(controlElement), Nodes.getQName(testElement));
        }
    };
    public static final ElementSelector byNameAndText = new ElementSelector(){

        @Override
        public boolean canBeCompared(Element controlElement, Element testElement) {
            return byName.canBeCompared(controlElement, testElement) && ElementSelectors.bothNullOrEqual(Nodes.getMergedNestedText(controlElement), Nodes.getMergedNestedText(testElement));
        }
    };
    public static final ElementSelector byNameAndAllAttributes = new ElementSelector(){

        @Override
        public boolean canBeCompared(Element controlElement, Element testElement) {
            if (!byName.canBeCompared(controlElement, testElement)) {
                return false;
            }
            Map<QName, String> cAttrs = Nodes.getAttributes(controlElement);
            Map<QName, String> tAttrs = Nodes.getAttributes(testElement);
            if (cAttrs.size() != tAttrs.size()) {
                return false;
            }
            return ElementSelectors.mapsEqualForKeys(cAttrs, tAttrs, cAttrs.keySet());
        }
    };
    private static final String SELECTORS_MUST_NOT_BE_NULL = "selectors must not be null";
    private static final String ATTRIBUTES_MUST_NOT_CONTAIN_NULL_VALUES = "attributes must not contain null values";
    private static final String ATTRIBUTES_MUST_NOT_BE_NULL = "attributes must not be null";
    static final Mapper<Node, XPathContext.NodeInfo> TO_NODE_INFO = new Mapper<Node, XPathContext.NodeInfo>(){

        @Override
        public XPathContext.NodeInfo apply(Node n) {
            return new XPathContext.DOMNodeInfo(n);
        }
    };

    private ElementSelectors() {
    }

    public static ElementSelector byNameAndAttributes(String ... attribs) {
        if (attribs == null) {
            throw new IllegalArgumentException(ATTRIBUTES_MUST_NOT_BE_NULL);
        }
        if (Linqy.any(Arrays.asList(attribs), new IsNullPredicate())) {
            throw new IllegalArgumentException(ATTRIBUTES_MUST_NOT_CONTAIN_NULL_VALUES);
        }
        QName[] qs = new QName[attribs.length];
        for (int i = 0; i < attribs.length; ++i) {
            qs[i] = new QName(attribs[i]);
        }
        return ElementSelectors.byNameAndAttributes(qs);
    }

    public static ElementSelector byNameAndAttributesControlNS(String ... attribs) {
        if (attribs == null) {
            throw new IllegalArgumentException(ATTRIBUTES_MUST_NOT_BE_NULL);
        }
        List<String> qs = Arrays.asList(attribs);
        if (Linqy.any(qs, new IsNullPredicate())) {
            throw new IllegalArgumentException(ATTRIBUTES_MUST_NOT_CONTAIN_NULL_VALUES);
        }
        final HashSet<String> as = new HashSet<String>(qs);
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                if (!byName.canBeCompared(controlElement, testElement)) {
                    return false;
                }
                Map<QName, String> cAttrs = Nodes.getAttributes(controlElement);
                HashMap<String, QName> qNameByLocalName = new HashMap<String, QName>();
                for (QName q : cAttrs.keySet()) {
                    String local = q.getLocalPart();
                    if (!as.contains(local)) continue;
                    qNameByLocalName.put(local, q);
                }
                for (String a : as) {
                    QName q = (QName)qNameByLocalName.get(a);
                    if (q != null) continue;
                    qNameByLocalName.put(a, new QName(a));
                }
                return ElementSelectors.mapsEqualForKeys(cAttrs, Nodes.getAttributes(testElement), qNameByLocalName.values());
            }
        };
    }

    public static ElementSelector byNameAndAttributes(QName ... attribs) {
        if (attribs == null) {
            throw new IllegalArgumentException(ATTRIBUTES_MUST_NOT_BE_NULL);
        }
        final List<QName> qs = Arrays.asList(attribs);
        if (Linqy.any(qs, new IsNullPredicate())) {
            throw new IllegalArgumentException(ATTRIBUTES_MUST_NOT_CONTAIN_NULL_VALUES);
        }
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                if (!byName.canBeCompared(controlElement, testElement)) {
                    return false;
                }
                return ElementSelectors.mapsEqualForKeys(Nodes.getAttributes(controlElement), Nodes.getAttributes(testElement), qs);
            }
        };
    }

    public static ElementSelector not(final ElementSelector es) {
        if (es == null) {
            throw new IllegalArgumentException("es must not be null");
        }
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                return !es.canBeCompared(controlElement, testElement);
            }
        };
    }

    public static ElementSelector or(ElementSelector ... selectors) {
        if (selectors == null) {
            throw new IllegalArgumentException(SELECTORS_MUST_NOT_BE_NULL);
        }
        final List<ElementSelector> s2 = Arrays.asList(selectors);
        if (Linqy.any(s2, new IsNullPredicate())) {
            throw new IllegalArgumentException("selectors must not contain null values");
        }
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                return Linqy.any(s2, new CanBeComparedPredicate(controlElement, testElement));
            }
        };
    }

    public static ElementSelector and(ElementSelector ... selectors) {
        if (selectors == null) {
            throw new IllegalArgumentException(SELECTORS_MUST_NOT_BE_NULL);
        }
        final List<ElementSelector> s2 = Arrays.asList(selectors);
        if (Linqy.any(s2, new IsNullPredicate())) {
            throw new IllegalArgumentException("selectors must not contain null values");
        }
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                return Linqy.all(s2, new CanBeComparedPredicate(controlElement, testElement));
            }
        };
    }

    public static ElementSelector xor(final ElementSelector es1, final ElementSelector es2) {
        if (es1 == null || es2 == null) {
            throw new IllegalArgumentException(SELECTORS_MUST_NOT_BE_NULL);
        }
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                return es1.canBeCompared(controlElement, testElement) ^ es2.canBeCompared(controlElement, testElement);
            }
        };
    }

    public static ElementSelector conditionalSelector(final Predicate<? super Element> predicate, final ElementSelector es) {
        if (predicate == null) {
            throw new IllegalArgumentException("predicate must not be null");
        }
        if (es == null) {
            throw new IllegalArgumentException("es must not be null");
        }
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                return predicate.test(controlElement) && es.canBeCompared(controlElement, testElement);
            }
        };
    }

    public static ElementSelector selectorForElementNamed(String expectedName, ElementSelector es) {
        if (expectedName == null) {
            throw new IllegalArgumentException("expectedName must not be null");
        }
        return ElementSelectors.conditionalSelector(ElementSelectors.elementNamePredicate(expectedName), es);
    }

    public static ElementSelector selectorForElementNamed(QName expectedName, ElementSelector es) {
        if (expectedName == null) {
            throw new IllegalArgumentException("expectedName must not be null");
        }
        return ElementSelectors.conditionalSelector(ElementSelectors.elementNamePredicate(expectedName), es);
    }

    public static ElementSelector byXPath(String xpath, ElementSelector childSelector) {
        return ElementSelectors.byXPath(xpath, null, childSelector);
    }

    public static ElementSelector byXPath(final String xpath, Map<String, String> prefix2Uri, ElementSelector childSelector) {
        final JAXPXPathEngine engine = new JAXPXPathEngine();
        if (prefix2Uri != null) {
            engine.setNamespaceContext(prefix2Uri);
        }
        final DefaultNodeMatcher nm = new DefaultNodeMatcher(childSelector);
        return new ElementSelector(){

            @Override
            public boolean canBeCompared(Element controlElement, Element testElement) {
                int matched;
                Iterable<Node> controlChildren = engine.selectNodes(xpath, controlElement);
                int expected = Linqy.count(controlChildren);
                return expected == (matched = Linqy.count(nm.match(controlChildren, engine.selectNodes(xpath, testElement))));
            }
        };
    }

    public static ConditionalSelectorBuilder conditionalBuilder() {
        return new DefaultConditionalSelectorBuilder();
    }

    private static boolean bothNullOrEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static boolean mapsEqualForKeys(Map<QName, String> control, Map<QName, String> test, Iterable<QName> keys) {
        for (QName q : keys) {
            if (ElementSelectors.bothNullOrEqual(control.get(q), test.get(q))) continue;
            return false;
        }
        return true;
    }

    static Predicate<Element> elementNamePredicate(final String expectedName) {
        return new Predicate<Element>(){

            @Override
            public boolean test(Element e) {
                if (e == null) {
                    return false;
                }
                String name = e.getLocalName();
                if (name == null) {
                    name = e.getNodeName();
                }
                return expectedName.equals(name);
            }
        };
    }

    static Predicate<Element> elementNamePredicate(final QName expectedName) {
        return new Predicate<Element>(){

            @Override
            public boolean test(Element e) {
                return e == null ? false : expectedName.equals(Nodes.getQName(e));
            }
        };
    }

    private static class CanBeComparedPredicate
    implements Predicate<ElementSelector> {
        private final Element e1;
        private final Element e2;

        private CanBeComparedPredicate(Element e1, Element e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean test(ElementSelector es) {
            return es.canBeCompared(this.e1, this.e2);
        }
    }

    public static interface ConditionalSelectorBuilder {
        public ConditionalSelectorBuilderThen when(Predicate<? super Element> var1);

        public ConditionalSelectorBuilderThen whenElementIsNamed(String var1);

        public ConditionalSelectorBuilderThen whenElementIsNamed(QName var1);

        public ConditionalSelectorBuilder elseUse(ElementSelector var1);

        public ElementSelector build();
    }

    public static interface ConditionalSelectorBuilderThen {
        public ConditionalSelectorBuilder thenUse(ElementSelector var1);
    }
}

