/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import java.nio.charset.Charset;
import java.util.List;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.collect.Lists;

public class ResponseDefinitionBuilder {
    private int status;
    private byte[] bodyContent;
    private boolean isBinaryBody = false;
    private String bodyFileName;
    private List<HttpHeader> headers = Lists.newArrayList();
    private Integer fixedDelayMilliseconds;
    private String proxyBaseUrl;
    private Fault fault;

    public static ResponseDefinition jsonResponse(Object body) {
        return new ResponseDefinitionBuilder().withBody(Json.write(body)).withStatus(200).withHeader("Content-Type", "application/json").build();
    }

    public ResponseDefinitionBuilder withStatus(int status) {
        this.status = status;
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String value) {
        this.headers.add(new HttpHeader(key, value));
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.bodyFileName = fileName;
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.bodyContent = body.getBytes(Charset.forName(Charsets.UTF_8.name()));
        this.isBinaryBody = false;
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.bodyContent = body;
        this.isBinaryBody = true;
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.fixedDelayMilliseconds = milliseconds;
        return this;
    }

    public ResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
        return this;
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.fault = fault;
        return this;
    }

    public ResponseDefinition build() {
        ResponseDefinition response = this.isBinaryBody ? new ResponseDefinition(this.status, this.bodyContent) : (this.bodyContent == null ? new ResponseDefinition(this.status, (String)null) : new ResponseDefinition(this.status, new String(this.bodyContent, Charset.forName(Charsets.UTF_8.name()))));
        if (!this.headers.isEmpty()) {
            response.setHeaders(new HttpHeaders(this.headers));
        }
        response.setBodyFileName(this.bodyFileName);
        response.setFixedDelayMilliseconds(this.fixedDelayMilliseconds);
        response.setProxyBaseUrl(this.proxyBaseUrl);
        response.setFault(this.fault);
        return response;
    }
}

