/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.VeryShortIdGenerator;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import java.util.Collection;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.Collections2;

public class JsonFileMappingsSaver
implements MappingsSaver {
    private final FileSource mappingsFileSource;
    private final VeryShortIdGenerator idGenerator;

    public JsonFileMappingsSaver(FileSource mappingsFileSource) {
        this.mappingsFileSource = mappingsFileSource;
        this.idGenerator = new VeryShortIdGenerator();
    }

    @Override
    public void saveMappings(StubMappings stubMappings) {
        Collection<StubMapping> transientStubs = Collections2.filter(stubMappings.getAll(), new Predicate<StubMapping>(){

            @Override
            public boolean apply(StubMapping input) {
                return input != null && input.isTransient();
            }
        });
        for (StubMapping mapping : transientStubs) {
            String fileId = this.idGenerator.generate();
            String mappingFileName = "saved-mapping-" + fileId + ".json";
            this.mappingsFileSource.writeTextFile(mappingFileName, Json.write(mapping));
            mapping.setTransient(false);
        }
    }
}

