/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import wiremock.com.fasterxml.jackson.annotation.JsonFormat;
import wiremock.com.fasterxml.jackson.core.JsonGenerationException;
import wiremock.com.fasterxml.jackson.core.JsonGenerator;
import wiremock.com.fasterxml.jackson.databind.BeanProperty;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.JsonSerializer;
import wiremock.com.fasterxml.jackson.databind.SerializationFeature;
import wiremock.com.fasterxml.jackson.databind.SerializerProvider;
import wiremock.com.fasterxml.jackson.databind.introspect.Annotated;
import wiremock.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import wiremock.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import wiremock.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import wiremock.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import wiremock.com.fasterxml.jackson.databind.util.StdDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> type, boolean useTimestamp, DateFormat customFormat) {
        super(type);
        this._useTimestamp = useTimestamp;
        this._customFormat = customFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        if (property != null && (format = prov.getAnnotationIntrospector().findFormat((Annotated)property.getMember())) != null) {
            if (format.getShape().isNumeric()) {
                return this.withFormat(true, null);
            }
            TimeZone tz = format.getTimeZone();
            String pattern = format.getPattern();
            if (pattern.length() > 0) {
                Locale loc = format.getLocale();
                if (loc == null) {
                    loc = prov.getLocale();
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = prov.getTimeZone();
                }
                df.setTimeZone(tz);
                return this.withFormat(false, df);
            }
            if (tz != null) {
                DateFormat df = prov.getConfig().getDateFormat();
                if (df.getClass() == StdDateFormat.class) {
                    df = StdDateFormat.getISO8601Format(tz);
                } else {
                    df = (DateFormat)df.clone();
                    df.setTimeZone(tz);
                }
                return this.withFormat(false, df);
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty(T value) {
        return value == null || this._timestamp(value) == 0L;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        boolean asNumber = this._useTimestamp;
        if (!asNumber && this._customFormat == null) {
            asNumber = provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        return this.createSchemaNode(asNumber ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        boolean asNumber = this._useTimestamp;
        if (!asNumber && this._customFormat == null) {
            asNumber = visitor.getProvider().isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        if (asNumber) {
            visitor.expectNumberFormat(typeHint).format(JsonValueFormat.UTC_MILLISEC);
        } else {
            visitor.expectStringFormat(typeHint).format(JsonValueFormat.DATE_TIME);
        }
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;
}

