/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import wiremock.com.fasterxml.jackson.core.JsonGenerationException;
import wiremock.com.fasterxml.jackson.core.JsonGenerator;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.SerializerProvider;
import wiremock.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import wiremock.com.fasterxml.jackson.databind.ser.std.StdSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdKeySerializer
extends StdSerializer<Object> {
    static final StdKeySerializer instace = new StdKeySerializer();

    public StdKeySerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (value instanceof Date) {
            provider.defaultSerializeDateKey((Date)value, jgen);
        } else {
            jgen.writeFieldName(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectStringFormat(typeHint);
    }
}

