/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.primitives;

import java.math.BigInteger;
import javax.annotation.Nullable;
import wiremock.com.google.common.annotations.Beta;
import wiremock.com.google.common.annotations.GwtCompatible;
import wiremock.com.google.common.annotations.GwtIncompatible;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.primitives.UnsignedInts;

@Beta
@GwtCompatible(emulated=true)
public final class UnsignedInteger
extends Number
implements Comparable<UnsignedInteger> {
    public static final UnsignedInteger ZERO = UnsignedInteger.asUnsigned(0);
    public static final UnsignedInteger ONE = UnsignedInteger.asUnsigned(1);
    public static final UnsignedInteger MAX_VALUE = UnsignedInteger.asUnsigned(-1);
    private final int value;

    private UnsignedInteger(int value) {
        this.value = value & 0xFFFFFFFF;
    }

    public static UnsignedInteger asUnsigned(int value) {
        return new UnsignedInteger(value);
    }

    public static UnsignedInteger valueOf(long value) {
        Preconditions.checkArgument((value & 0xFFFFFFFFL) == value, "value (%s) is outside the range for an unsigned integer value", value);
        return UnsignedInteger.asUnsigned((int)value);
    }

    public static UnsignedInteger valueOf(BigInteger value) {
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.signum() >= 0 && value.bitLength() <= 32, "value (%s) is outside the range for an unsigned integer value", value);
        return UnsignedInteger.asUnsigned(value.intValue());
    }

    public static UnsignedInteger valueOf(String string) {
        return UnsignedInteger.valueOf(string, 10);
    }

    public static UnsignedInteger valueOf(String string, int radix) {
        return UnsignedInteger.asUnsigned(UnsignedInts.parseUnsignedInt(string, radix));
    }

    public UnsignedInteger add(UnsignedInteger val) {
        Preconditions.checkNotNull(val);
        return UnsignedInteger.asUnsigned(this.value + val.value);
    }

    public UnsignedInteger subtract(UnsignedInteger val) {
        Preconditions.checkNotNull(val);
        return UnsignedInteger.asUnsigned(this.value - val.value);
    }

    @GwtIncompatible(value="Does not truncate correctly")
    public UnsignedInteger multiply(UnsignedInteger val) {
        Preconditions.checkNotNull(val);
        return UnsignedInteger.asUnsigned(this.value * val.value);
    }

    public UnsignedInteger divide(UnsignedInteger val) {
        Preconditions.checkNotNull(val);
        return UnsignedInteger.asUnsigned(UnsignedInts.divide(this.value, val.value));
    }

    public UnsignedInteger remainder(UnsignedInteger val) {
        Preconditions.checkNotNull(val);
        return UnsignedInteger.asUnsigned(UnsignedInts.remainder(this.value, val.value));
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return UnsignedInts.toLong(this.value);
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public int compareTo(UnsignedInteger other) {
        Preconditions.checkNotNull(other);
        return UnsignedInts.compare(this.value, other.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UnsignedInteger) {
            UnsignedInteger other = (UnsignedInteger)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int radix) {
        return UnsignedInts.toString(this.value, radix);
    }
}

