/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.client;

import wiremock.org.apache.http.HttpVersion;
import wiremock.org.apache.http.annotation.ThreadSafe;
import wiremock.org.apache.http.client.protocol.RequestAddCookies;
import wiremock.org.apache.http.client.protocol.RequestAuthCache;
import wiremock.org.apache.http.client.protocol.RequestClientConnControl;
import wiremock.org.apache.http.client.protocol.RequestDefaultHeaders;
import wiremock.org.apache.http.client.protocol.RequestProxyAuthentication;
import wiremock.org.apache.http.client.protocol.RequestTargetAuthentication;
import wiremock.org.apache.http.client.protocol.ResponseProcessCookies;
import wiremock.org.apache.http.conn.ClientConnectionManager;
import wiremock.org.apache.http.impl.client.AbstractHttpClient;
import wiremock.org.apache.http.params.HttpConnectionParams;
import wiremock.org.apache.http.params.HttpParams;
import wiremock.org.apache.http.params.HttpProtocolParams;
import wiremock.org.apache.http.params.SyncBasicHttpParams;
import wiremock.org.apache.http.protocol.BasicHttpProcessor;
import wiremock.org.apache.http.protocol.HTTP;
import wiremock.org.apache.http.protocol.RequestContent;
import wiremock.org.apache.http.protocol.RequestExpectContinue;
import wiremock.org.apache.http.protocol.RequestTargetHost;
import wiremock.org.apache.http.protocol.RequestUserAgent;
import wiremock.org.apache.http.util.VersionInfo;

@ThreadSafe
public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public DefaultHttpClient(ClientConnectionManager conman) {
        super(conman, null);
    }

    public DefaultHttpClient(HttpParams params) {
        super(null, params);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams(params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("wiremock.org.apache.http.client", DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestAuthCache());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }
}

