/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert.comparator;

import java.util.Arrays;
import java.util.Collection;
import wiremock.org.json.JSONException;
import wiremock.org.skyscreamer.jsonassert.Customization;
import wiremock.org.skyscreamer.jsonassert.JSONCompareMode;
import wiremock.org.skyscreamer.jsonassert.JSONCompareResult;
import wiremock.org.skyscreamer.jsonassert.comparator.DefaultComparator;

public class CustomComparator
extends DefaultComparator {
    private final Collection<Customization> customizations;

    public CustomComparator(JSONCompareMode mode, Customization ... customizations) {
        super(mode);
        this.customizations = Arrays.asList(customizations);
    }

    @Override
    public void compareValues(String prefix, Object expectedValue, Object actualValue, JSONCompareResult result) throws JSONException {
        Customization customization = this.getCustomization(prefix);
        if (customization != null) {
            if (!customization.matches(actualValue, expectedValue)) {
                result.fail(prefix, expectedValue, actualValue);
            }
        } else {
            super.compareValues(prefix, expectedValue, actualValue, result);
        }
    }

    private Customization getCustomization(String path) {
        for (Customization c : this.customizations) {
            if (!c.appliesToPath(path)) continue;
            return c;
        }
        return null;
    }
}

