/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.encryptor.FixedBase64ByteArraySaltGenerator;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.jasypt.iv.IvGenerator;
import org.jasypt.salt.SaltGenerator;
import org.jasypt.salt.ZeroSaltGenerator;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class SimpleGCMConfig {
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Resource secretKeyResource;
    private String secretKeyLocation;
    private String secretKey;
    private String secretKeyPassword;
    private String secretKeySalt;
    private String algorithm = "AES/GCM/NoPadding";
    private String secretKeyAlgorithm = "PBKDF2WithHmacSHA256";
    private int secretKeyIterations = 1000;
    private SecretKey actualKey = null;
    private SaltGenerator saltGenerator = null;
    private IvGenerator ivGenerator = null;
    private String ivGeneratorClassName = "org.jasypt.iv.RandomIvGenerator";

    private Resource loadResource(Resource asResource, String asString, String asLocation) {
        return Optional.ofNullable(asResource).orElseGet(() -> Optional.ofNullable(asString).map(pk -> new ByteArrayResource(pk.getBytes(StandardCharsets.UTF_8))).orElseGet(() -> Optional.ofNullable(asLocation).map(arg_0 -> ((ResourceLoader)this.resourceLoader).getResource(arg_0)).orElseThrow(() -> new IllegalArgumentException("Unable to load secret key. Either resource, key as string, or resource location must be provided"))));
    }

    public Resource loadSecretKeyResource() {
        return this.loadResource(this.secretKeyResource, this.secretKey, this.secretKeyLocation);
    }

    public char[] getSecretKeyPasswordChars() {
        return this.secretKeyPassword.toCharArray();
    }

    public SaltGenerator getSecretKeySaltGenerator() {
        return this.saltGenerator != null ? this.saltGenerator : (this.secretKeySalt == null ? new ZeroSaltGenerator() : new FixedBase64ByteArraySaltGenerator(this.secretKeySalt));
    }

    private IvGenerator instantiateIvGenerator() {
        return (IvGenerator)Class.forName(this.ivGeneratorClassName).newInstance();
    }

    public IvGenerator getActualIvGenerator() {
        return Optional.ofNullable(this.ivGenerator).orElseGet(this::instantiateIvGenerator);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Resource getSecretKeyResource() {
        return this.secretKeyResource;
    }

    public String getSecretKeyLocation() {
        return this.secretKeyLocation;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSecretKeyPassword() {
        return this.secretKeyPassword;
    }

    public String getSecretKeySalt() {
        return this.secretKeySalt;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    public int getSecretKeyIterations() {
        return this.secretKeyIterations;
    }

    public SecretKey getActualKey() {
        return this.actualKey;
    }

    public SaltGenerator getSaltGenerator() {
        return this.saltGenerator;
    }

    public IvGenerator getIvGenerator() {
        return this.ivGenerator;
    }

    public String getIvGeneratorClassName() {
        return this.ivGeneratorClassName;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setSecretKeyResource(Resource secretKeyResource) {
        this.secretKeyResource = secretKeyResource;
    }

    public void setSecretKeyLocation(String secretKeyLocation) {
        this.secretKeyLocation = secretKeyLocation;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSecretKeyPassword(String secretKeyPassword) {
        this.secretKeyPassword = secretKeyPassword;
    }

    public void setSecretKeySalt(String secretKeySalt) {
        this.secretKeySalt = secretKeySalt;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    public void setSecretKeyIterations(int secretKeyIterations) {
        this.secretKeyIterations = secretKeyIterations;
    }

    public void setActualKey(SecretKey actualKey) {
        this.actualKey = actualKey;
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public void setIvGenerator(IvGenerator ivGenerator) {
        this.ivGenerator = ivGenerator;
    }

    public void setIvGeneratorClassName(String ivGeneratorClassName) {
        this.ivGeneratorClassName = ivGeneratorClassName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleGCMConfig)) {
            return false;
        }
        SimpleGCMConfig other = (SimpleGCMConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSecretKeyIterations() != other.getSecretKeyIterations()) {
            return false;
        }
        ResourceLoader this$resourceLoader = this.getResourceLoader();
        ResourceLoader other$resourceLoader = other.getResourceLoader();
        if (this$resourceLoader == null ? other$resourceLoader != null : !this$resourceLoader.equals(other$resourceLoader)) {
            return false;
        }
        Resource this$secretKeyResource = this.getSecretKeyResource();
        Resource other$secretKeyResource = other.getSecretKeyResource();
        if (this$secretKeyResource == null ? other$secretKeyResource != null : !this$secretKeyResource.equals(other$secretKeyResource)) {
            return false;
        }
        String this$secretKeyLocation = this.getSecretKeyLocation();
        String other$secretKeyLocation = other.getSecretKeyLocation();
        if (this$secretKeyLocation == null ? other$secretKeyLocation != null : !this$secretKeyLocation.equals(other$secretKeyLocation)) {
            return false;
        }
        String this$secretKey = this.getSecretKey();
        String other$secretKey = other.getSecretKey();
        if (this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey)) {
            return false;
        }
        String this$secretKeyPassword = this.getSecretKeyPassword();
        String other$secretKeyPassword = other.getSecretKeyPassword();
        if (this$secretKeyPassword == null ? other$secretKeyPassword != null : !this$secretKeyPassword.equals(other$secretKeyPassword)) {
            return false;
        }
        String this$secretKeySalt = this.getSecretKeySalt();
        String other$secretKeySalt = other.getSecretKeySalt();
        if (this$secretKeySalt == null ? other$secretKeySalt != null : !this$secretKeySalt.equals(other$secretKeySalt)) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        String this$secretKeyAlgorithm = this.getSecretKeyAlgorithm();
        String other$secretKeyAlgorithm = other.getSecretKeyAlgorithm();
        if (this$secretKeyAlgorithm == null ? other$secretKeyAlgorithm != null : !this$secretKeyAlgorithm.equals(other$secretKeyAlgorithm)) {
            return false;
        }
        SecretKey this$actualKey = this.getActualKey();
        SecretKey other$actualKey = other.getActualKey();
        if (this$actualKey == null ? other$actualKey != null : !this$actualKey.equals(other$actualKey)) {
            return false;
        }
        SaltGenerator this$saltGenerator = this.getSaltGenerator();
        SaltGenerator other$saltGenerator = other.getSaltGenerator();
        if (this$saltGenerator == null ? other$saltGenerator != null : !this$saltGenerator.equals(other$saltGenerator)) {
            return false;
        }
        IvGenerator this$ivGenerator = this.getIvGenerator();
        IvGenerator other$ivGenerator = other.getIvGenerator();
        if (this$ivGenerator == null ? other$ivGenerator != null : !this$ivGenerator.equals(other$ivGenerator)) {
            return false;
        }
        String this$ivGeneratorClassName = this.getIvGeneratorClassName();
        String other$ivGeneratorClassName = other.getIvGeneratorClassName();
        return !(this$ivGeneratorClassName == null ? other$ivGeneratorClassName != null : !this$ivGeneratorClassName.equals(other$ivGeneratorClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleGCMConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSecretKeyIterations();
        ResourceLoader $resourceLoader = this.getResourceLoader();
        result = result * 59 + ($resourceLoader == null ? 43 : $resourceLoader.hashCode());
        Resource $secretKeyResource = this.getSecretKeyResource();
        result = result * 59 + ($secretKeyResource == null ? 43 : $secretKeyResource.hashCode());
        String $secretKeyLocation = this.getSecretKeyLocation();
        result = result * 59 + ($secretKeyLocation == null ? 43 : $secretKeyLocation.hashCode());
        String $secretKey = this.getSecretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        String $secretKeyPassword = this.getSecretKeyPassword();
        result = result * 59 + ($secretKeyPassword == null ? 43 : $secretKeyPassword.hashCode());
        String $secretKeySalt = this.getSecretKeySalt();
        result = result * 59 + ($secretKeySalt == null ? 43 : $secretKeySalt.hashCode());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        String $secretKeyAlgorithm = this.getSecretKeyAlgorithm();
        result = result * 59 + ($secretKeyAlgorithm == null ? 43 : $secretKeyAlgorithm.hashCode());
        SecretKey $actualKey = this.getActualKey();
        result = result * 59 + ($actualKey == null ? 43 : $actualKey.hashCode());
        SaltGenerator $saltGenerator = this.getSaltGenerator();
        result = result * 59 + ($saltGenerator == null ? 43 : $saltGenerator.hashCode());
        IvGenerator $ivGenerator = this.getIvGenerator();
        result = result * 59 + ($ivGenerator == null ? 43 : $ivGenerator.hashCode());
        String $ivGeneratorClassName = this.getIvGeneratorClassName();
        result = result * 59 + ($ivGeneratorClassName == null ? 43 : $ivGeneratorClassName.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleGCMConfig(resourceLoader=" + this.getResourceLoader() + ", secretKeyResource=" + this.getSecretKeyResource() + ", secretKeyLocation=" + this.getSecretKeyLocation() + ", secretKey=" + this.getSecretKey() + ", secretKeyPassword=" + this.getSecretKeyPassword() + ", secretKeySalt=" + this.getSecretKeySalt() + ", algorithm=" + this.getAlgorithm() + ", secretKeyAlgorithm=" + this.getSecretKeyAlgorithm() + ", secretKeyIterations=" + this.getSecretKeyIterations() + ", actualKey=" + this.getActualKey() + ", saltGenerator=" + this.getSaltGenerator() + ", ivGenerator=" + this.getIvGenerator() + ", ivGeneratorClassName=" + this.getIvGeneratorClassName() + ")";
    }
}

