/*
 * Decompiled with CFR 0.152.
 */
package wrm;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import wrm.AbstractSassMojo;

public class WatchMojo
extends AbstractSassMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfig();
        this.compiler = this.initCompiler();
        this.inputPath = this.inputPath.replaceAll("\\\\", "/");
        this.getLog().debug((CharSequence)("Input Path=" + this.inputPath));
        this.getLog().debug((CharSequence)("Output Path=" + this.outputPath));
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            this.registerWatchDirectories(watcher);
            this.getLog().info((CharSequence)("Watching [" + this.inputPath + "]..."));
            try {
                WatchKey key;
                long lastModified = 0L;
                block15: do {
                    key = watcher.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                        Path modifiedFile = ((Path)key.watchable()).resolve((Path)event.context());
                        if (modifiedFile.toFile().lastModified() - lastModified > 1000L) {
                            this.getLog().debug((CharSequence)String.format("%s: %s", event.kind().name(), modifiedFile));
                            try {
                                this.compile();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        lastModified = modifiedFile.toFile().lastModified();
                        continue block15;
                    }
                } while (key.reset());
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)"Watch service interrupted");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while watching: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
        }
    }

    private void registerWatchDirectories(WatchService watcher) throws IOException {
        Path root = this.project.getBasedir().toPath().resolve(Paths.get(this.inputPath, new String[0]));
        this.registerAll(root, watcher);
        if (this.includePath != null) {
            for (String inclPath : this.includePath.split(";")) {
                Path incl = this.project.getBasedir().toPath().resolve(Paths.get(inclPath, new String[0]));
                this.registerAll(incl, watcher);
            }
        }
    }

    private void registerAll(Path start, final WatchService watcher) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

