/*
 * Decompiled with CFR 0.152.
 */
package wrm.libsass;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.webjars.WebJarAssetLocator;

class WebJarTranslator {
    private static final Pattern WEBJAR_PATTERN = Pattern.compile("META-INF/resources/webjars/([^/]+)/([^/]+)/(.*)");
    private final Map<String, String> index = WebJarAssetLocator.getFullPathIndex((Pattern)Pattern.compile(".*"), (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}).values().stream().map(WEBJAR_PATTERN::matcher).filter(Matcher::matches).collect(Collectors.toMap(WebJarTranslator::convertMatchedPath, m -> m.group(0)));

    WebJarTranslator() {
    }

    private static String convertMatchedPath(Matcher matcher) {
        String name = matcher.group(1);
        String path = matcher.group(3);
        return name + "/" + path;
    }

    Optional<URI> translate(URI uri) {
        String fullPath = this.index.get(uri.toString());
        return fullPath == null ? Optional.empty() : Optional.of(URI.create(fullPath));
    }
}

