/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesVerifier
implements Verifier {
    private static final Logger log = LoggerFactory.getLogger(CertificatesVerifier.class);
    protected final HashMap<BigInteger, X509Certificate> certificates = new HashMap();

    public CertificatesVerifier(List<X509Certificate> list) {
        for (X509Certificate item : list) {
            this.certificates.put(item.getSerialNumber(), item);
        }
    }

    public CertificatesVerifier(Map<BigInteger, X509Certificate> certificates) {
        this.certificates.putAll(certificates);
    }

    public void updateCertificates(Map<BigInteger, X509Certificate> certificates) {
        this.certificates.clear();
        this.certificates.putAll(certificates);
    }

    protected boolean verify(X509Certificate certificate, byte[] message, String signature) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initVerify(certificate);
            sign.update(message);
            return sign.verify(Base64.getDecoder().decode(signature));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", e);
        }
        catch (SignatureException e) {
            throw new RuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u8fc7\u7a0b\u53d1\u751f\u4e86\u9519\u8bef", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
    }

    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        BigInteger val = new BigInteger(serialNumber, 16);
        X509Certificate cert = this.certificates.get(val);
        if (cert == null) {
            log.error("\u627e\u4e0d\u5230\u8bc1\u4e66\u5e8f\u5217\u53f7\u5bf9\u5e94\u7684\u8bc1\u4e66\uff0c\u5e8f\u5217\u53f7\uff1a{}", (Object)serialNumber);
            return false;
        }
        return this.verify(cert, message, signature);
    }

    @Override
    public X509Certificate getValidCertificate() {
        X509Certificate latestCert = null;
        for (X509Certificate x509Cert : this.certificates.values()) {
            if (latestCert != null && !x509Cert.getNotBefore().after(latestCert.getNotBefore())) continue;
            latestCert = x509Cert;
        }
        try {
            latestCert.checkValidity();
            return latestCert;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            throw new NoSuchElementException("\u6ca1\u6709\u6709\u6548\u7684\u5fae\u4fe1\u652f\u4ed8\u5e73\u53f0\u8bc1\u4e66");
        }
    }
}

