/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.auth.WechatPay2Credential;
import com.wechat.pay.java.core.auth.WechatPay2Validator;
import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.cipher.PrivacyDecryptor;
import com.wechat.pay.java.core.cipher.PrivacyEncryptor;
import com.wechat.pay.java.core.cipher.RSAPrivacyDecryptor;
import com.wechat.pay.java.core.cipher.RSAPrivacyEncryptor;
import com.wechat.pay.java.core.cipher.RSASigner;
import com.wechat.pay.java.core.cipher.RSAVerifier;
import com.wechat.pay.java.core.cipher.Signer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public abstract class AbstractRSAConfig
implements Config {
    private final String merchantId;
    private final PrivateKey privateKey;
    private final String merchantSerialNumber;
    private final CertificateProvider certificateProvider;

    protected AbstractRSAConfig(String merchantId, PrivateKey privateKey, String merchantSerialNumber, CertificateProvider certificateProvider) {
        this.merchantId = merchantId;
        this.privateKey = privateKey;
        this.merchantSerialNumber = merchantSerialNumber;
        this.certificateProvider = certificateProvider;
    }

    @Override
    public PrivacyEncryptor createEncryptor() {
        X509Certificate certificate = this.certificateProvider.getAvailableCertificate();
        return new RSAPrivacyEncryptor(certificate.getPublicKey(), certificate.getSerialNumber().toString(16));
    }

    @Override
    public PrivacyDecryptor createDecryptor() {
        return new RSAPrivacyDecryptor(this.privateKey);
    }

    @Override
    public Credential createCredential() {
        return new WechatPay2Credential(this.merchantId, this.createSigner());
    }

    @Override
    public Validator createValidator() {
        return new WechatPay2Validator(new RSAVerifier(this.certificateProvider));
    }

    @Override
    public Signer createSigner() {
        return new RSASigner(this.merchantSerialNumber, this.privateKey);
    }
}

