/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.certificate;

import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.auth.WechatPay2Validator;
import com.wechat.pay.java.core.certificate.CertificateHandler;
import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.certificate.SafeSingleScheduleExecutor;
import com.wechat.pay.java.core.certificate.model.Data;
import com.wechat.pay.java.core.certificate.model.DownloadCertificateResponse;
import com.wechat.pay.java.core.certificate.model.EncryptCertificate;
import com.wechat.pay.java.core.cipher.AeadCipher;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonResponseBody;
import com.wechat.pay.java.core.http.MediaType;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutoCertificateProvider
implements CertificateProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractAutoCertificateProvider.class);
    protected static final int UPDATE_INTERVAL_MINUTE = 60;
    protected final SafeSingleScheduleExecutor executor = SafeSingleScheduleExecutor.getInstance();
    protected String requestUrl;
    protected String merchantId;
    protected CertificateHandler certificateHandler;
    protected AeadCipher aeadCipher;
    protected HttpClient httpClient;
    private final HttpRequest httpRequest;
    private Validator validator;
    private int updateTime;
    private final Map<String, Map<String, X509Certificate>> certificateMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAutoCertificateProvider(String requestUrl, CertificateHandler certificateHandler, AeadCipher aeadCipher, HttpClient httpClient, String merchantId, Map<String, Map<String, X509Certificate>> wechatPayCertificateMap) {
        this.merchantId = merchantId;
        Class<AbstractAutoCertificateProvider> clazz = AbstractAutoCertificateProvider.class;
        synchronized (AbstractAutoCertificateProvider.class) {
            if (wechatPayCertificateMap.containsKey(merchantId)) {
                throw new IllegalStateException("The corresponding provider for the merchant already exists.");
            }
            wechatPayCertificateMap.put(merchantId, new HashMap());
            // ** MonitorExit[var7_7] (shouldn't be in output)
            this.requestUrl = requestUrl;
            this.certificateHandler = certificateHandler;
            this.aeadCipher = aeadCipher;
            this.httpClient = httpClient;
            this.certificateMap = wechatPayCertificateMap;
            this.httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestUrl).addHeader("Accept", " */*").addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue()).build();
            this.downloadAndUpdate(wechatPayCertificateMap);
            Runnable runnable = () -> {
                log.info("Begin update Certificates.merchantId:{},total updates:{}", (Object)merchantId, (Object)this.updateTime);
                this.downloadAndUpdate(wechatPayCertificateMap);
                log.info("Finish update Certificates.merchantId:{},total updates:{}", (Object)merchantId, (Object)this.updateTime);
            };
            this.executor.scheduleAtFixedRate(runnable, 60L, 60L, TimeUnit.MINUTES);
            return;
        }
    }

    protected void downloadAndUpdate(Map<String, Map<String, X509Certificate>> wechatPayCertificateMap) {
        try {
            HttpResponse<DownloadCertificateResponse> httpResponse = this.downloadCertificate(this.httpClient);
            this.validateCertificate(httpResponse);
            this.updateCertificate(httpResponse, wechatPayCertificateMap);
            this.validator = new WechatPay2Validator(this.certificateHandler.generateVerifier(new ArrayList<X509Certificate>(wechatPayCertificateMap.get(this.merchantId).values())));
            ++this.updateTime;
        }
        catch (Exception e) {
            if (this.validator == null) {
                throw e;
            }
            log.error("Download and update WechatPay certificates failed.", (Throwable)e);
        }
    }

    protected HttpResponse<DownloadCertificateResponse> downloadCertificate(HttpClient httpClient) {
        HttpResponse<DownloadCertificateResponse> httpResponse = httpClient.execute(this.httpRequest, DownloadCertificateResponse.class);
        return httpResponse;
    }

    protected void validateCertificate(HttpResponse<DownloadCertificateResponse> httpResponse) {
        JsonResponseBody responseBody = (JsonResponseBody)httpResponse.getBody();
        if (this.validator != null && !this.validator.validate(httpResponse.getHeaders(), responseBody.getBody())) {
            throw new ValidationException(String.format("Validate response failed,the WechatPay signature is incorrect.responseHeader[%s]\tresponseBody[%.1024s]", httpResponse.getHeaders(), httpResponse.getServiceResponse()));
        }
    }

    protected void updateCertificate(HttpResponse<DownloadCertificateResponse> httpResponse, Map<String, Map<String, X509Certificate>> wechatPayCertificateMap) {
        List<Data> dataList = httpResponse.getServiceResponse().getData();
        HashMap<String, X509Certificate> downloadCertMap = new HashMap<String, X509Certificate>();
        for (Data data : dataList) {
            EncryptCertificate encryptCertificate = data.getEncryptCertificate();
            String decryptCertificate = this.aeadCipher.decrypt(encryptCertificate.getAssociatedData().getBytes(StandardCharsets.UTF_8), encryptCertificate.getNonce().getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(encryptCertificate.getCiphertext()));
            X509Certificate certificate = this.certificateHandler.generateCertificate(decryptCertificate);
            downloadCertMap.put(certificate.getSerialNumber().toString(16).toUpperCase(), certificate);
        }
        wechatPayCertificateMap.put(this.merchantId, downloadCertMap);
    }

    public X509Certificate getAvailableCertificate(Map<String, X509Certificate> certificateMap) {
        X509Certificate longest = null;
        for (X509Certificate item : certificateMap.values()) {
            if (longest != null && !item.getNotAfter().after(longest.getNotAfter())) continue;
            longest = item;
        }
        return longest;
    }

    @Override
    public X509Certificate getCertificate(String serialNumber) {
        return this.certificateMap.get(this.merchantId).get(serialNumber);
    }

    @Override
    public X509Certificate getAvailableCertificate() {
        return this.getAvailableCertificate(this.certificateMap.get(this.merchantId));
    }
}

