/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http.okhttp;

import com.wechat.pay.java.core.auth.Credential;
import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.http.AbstractHttpClient;
import com.wechat.pay.java.core.http.FileRequestBody;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.OriginalResponse;
import com.wechat.pay.java.core.http.RequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OkHttpClientAdapter
extends AbstractHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(OkHttpClientAdapter.class);
    private static final String META_NAME = "meta";
    private static final String FILE_NAME = "file";
    private final OkHttpClient okHttpClient;

    public OkHttpClientAdapter(Credential credential, Validator validator, OkHttpClient client) {
        super(credential, validator);
        this.okHttpClient = Objects.requireNonNull(client);
    }

    @Override
    protected String getHttpClientInfo() {
        return "okhttp3/" + this.okHttpClient.getClass().getPackage().getImplementationVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OriginalResponse innerExecute(HttpRequest wechatPayRequest) {
        Request okHttpRequest = this.buildOkHttpRequest(wechatPayRequest);
        try (Response okHttpResponse = this.okHttpClient.newCall(okHttpRequest).execute();){
            OriginalResponse originalResponse = this.assembleOriginalResponse(wechatPayRequest, okHttpResponse);
            return originalResponse;
        }
        catch (IOException e) {
            throw new HttpException(wechatPayRequest, (Throwable)e);
        }
    }

    private Request buildOkHttpRequest(HttpRequest wechatPayRequest) {
        Request.Builder okHttpRequestBuilder = new Request.Builder().url(wechatPayRequest.getUrl());
        Map<String, String> headers = wechatPayRequest.getHeaders().getHeaders();
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)okHttpRequestBuilder).addHeader(arg_0, arg_1));
        String method = wechatPayRequest.getHttpMethod().name();
        okhttp3.RequestBody okHttpRequestBody = this.buildOkHttpRequestBody(wechatPayRequest.getBody());
        okHttpRequestBuilder.method(method, okHttpRequestBody);
        return okHttpRequestBuilder.build();
    }

    private okhttp3.RequestBody buildOkHttpRequestBody(RequestBody wechatPayRequestBody) {
        if (wechatPayRequestBody == null) {
            return null;
        }
        if (wechatPayRequestBody instanceof JsonRequestBody) {
            return this.createOkHttpRequestBody(wechatPayRequestBody);
        }
        if (wechatPayRequestBody instanceof FileRequestBody) {
            return this.createOkHttpMultipartRequestBody(wechatPayRequestBody);
        }
        logger.error("When an http request is sent and the okhttp request body is constructed, the requestBody parameter type cannot be found,requestBody class name[{}]", (Object)wechatPayRequestBody.getClass().getName());
        return null;
    }

    private okhttp3.RequestBody createRequestBody(String content, MediaType mediaType) {
        return okhttp3.RequestBody.create((MediaType)mediaType, (String)content);
    }

    private okhttp3.RequestBody createRequestBody(byte[] content, MediaType mediaType) {
        return okhttp3.RequestBody.create((MediaType)mediaType, (byte[])content);
    }

    private okhttp3.RequestBody createOkHttpRequestBody(RequestBody wechatPayRequestBody) {
        return this.createRequestBody(((JsonRequestBody)wechatPayRequestBody).getBody(), MediaType.parse((String)wechatPayRequestBody.getContentType()));
    }

    private okhttp3.RequestBody createOkHttpMultipartRequestBody(RequestBody wechatPayRequestBody) {
        FileRequestBody fileRequestBody = (FileRequestBody)wechatPayRequestBody;
        okhttp3.RequestBody okHttpFileBody = this.createRequestBody(fileRequestBody.getFile(), MediaType.parse((String)fileRequestBody.getContentType()));
        return new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart(META_NAME, fileRequestBody.getMeta()).addFormDataPart(FILE_NAME, fileRequestBody.getFileName(), okHttpFileBody).build();
    }

    private Map<String, String> assembleResponseHeader(Response okHttpResponse) {
        ConcurrentHashMap<String, String> responseHeaders = new ConcurrentHashMap<String, String>();
        int headerSize = okHttpResponse.headers().size();
        for (int i = 0; i < headerSize; ++i) {
            responseHeaders.put(okHttpResponse.headers().name(i), okHttpResponse.headers().value(i));
        }
        return responseHeaders;
    }

    private OriginalResponse assembleOriginalResponse(HttpRequest wechatPayRequest, Response okHttpResponse) {
        Map<String, String> responseHeaders = this.assembleResponseHeader(okHttpResponse);
        try {
            return new OriginalResponse.Builder().request(wechatPayRequest).headers(responseHeaders).statusCode(okHttpResponse.code()).contentType(okHttpResponse.body() == null || okHttpResponse.body().contentType() == null ? null : okHttpResponse.body().contentType().toString()).body(okHttpResponse.body().string()).build();
        }
        catch (IOException e) {
            throw new MalformedMessageException(String.format("Assemble OriginalResponse,get responseBody failed.%nHttpRequest[%s]", wechatPayRequest));
        }
    }

    @Override
    protected InputStream innerDownload(HttpRequest httpRequest) {
        Request okHttpRequest = this.buildOkHttpRequest(httpRequest);
        try {
            Response okHttpResponse = this.okHttpClient.newCall(okHttpRequest).execute();
            if (this.isInvalidHttpCode(okHttpResponse.code())) {
                throw new ServiceException(httpRequest, okHttpResponse.code(), "");
            }
            InputStream responseBodyStream = null;
            if (okHttpResponse.body() != null) {
                responseBodyStream = okHttpResponse.body().byteStream();
            }
            return responseBodyStream;
        }
        catch (IOException e) {
            throw new HttpException(httpRequest, (Throwable)e);
        }
    }
}

