/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.notification;

import com.wechat.pay.java.core.util.GsonUtil;

public class RequestParam {
    private final String serialNumber;
    private final String signature;
    private final String message;
    private final String body;
    private final String signType;

    private RequestParam(String serialNumber, String signature, String message, String body, String signType) {
        this.serialNumber = serialNumber;
        this.signature = signature;
        this.message = message;
        this.body = body;
        this.signType = signType == null || signType.isEmpty() ? "WECHATPAY2-SHA256-RSA2048" : signType;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getBody() {
        return this.body;
    }

    public String getSignType() {
        return this.signType;
    }

    public String toString() {
        return GsonUtil.getGson().toJson((Object)this);
    }

    public static class Builder {
        String signType;
        private String serialNumber;
        private String timestamp;
        private String nonce;
        private String signature;
        private String body;

        public Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public Builder signType(String signType) {
            this.signType = signType;
            return this;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public RequestParam build() {
            String message = this.timestamp + "\n" + this.nonce + "\n" + this.body + "\n";
            return new RequestParam(this.serialNumber, this.signature, message, this.body, this.signType);
        }
    }
}

