/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.block.factory.primitive.BooleanPredicates;
import com.gs.collections.impl.factory.primitive.BooleanSets;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.utility.internal.primitive.BooleanIterableIterate;
import com.gs.collections.impl.utility.primitive.LazyBooleanIterate;

/**
 * This file was automatically generated from template file abstractLazyPrimitiveIterable.stg.
 * @since 5.0
 */
public abstract class AbstractLazyBooleanIterable implements LazyBooleanIterable
{
    public int size()
    {
        return this.count(BooleanPredicates.alwaysTrue());
    }

    @Override
    public String toString()
    {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty()
    {
        return BooleanIterableIterate.isEmpty(this);
    }

    public boolean notEmpty()
    {
        return BooleanIterableIterate.notEmpty(this);
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        BooleanIterableIterate.appendString(this, appendable, start, separator, end);
    }

    public boolean contains(boolean value)
    {
        return this.anySatisfy(BooleanPredicates.equal(value));
    }

    public boolean containsAll(boolean... source)
    {
        return this.containsAll(BooleanSets.immutable.of(source));
    }

    public boolean containsAll(BooleanIterable source)
    {
        return source.allSatisfy(new BooleanPredicate()
        {
            public boolean accept(boolean value)
            {
                return AbstractLazyBooleanIterable.this.contains(value);
            }
        });
    }

    public LazyBooleanIterable select(BooleanPredicate predicate)
    {
        return LazyBooleanIterate.select(this, predicate);
    }

    public LazyBooleanIterable reject(BooleanPredicate predicate)
    {
        return LazyBooleanIterate.select(this, BooleanPredicates.not(predicate));
    }

    public <V> LazyIterable<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return LazyBooleanIterate.collect(this, function);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return BooleanIterableIterate.detectIfNone(this, predicate, ifNone);
    }

    public int count(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.count(this, predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.anySatisfy(this, predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.allSatisfy(this, predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return BooleanIterableIterate.noneSatisfy(this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return BooleanIterableIterate.injectInto(this, injectedValue, function);
    }


    public boolean[] toArray()
    {
        return this.toList().toArray();
    }

    public MutableBooleanList toList()
    {
        final MutableBooleanList list = new BooleanArrayList();
        this.forEach(new BooleanProcedure()
        {
            public void value(boolean each)
            {
                list.add(each);
            }
        });
        return list;
    }

    public MutableBooleanSet toSet()
    {
        final MutableBooleanSet set = new BooleanHashSet();
        this.forEach(new BooleanProcedure()
        {
            public void value(boolean each)
            {
                set.add(each);
            }
        });
        return set;
    }

    public MutableBooleanBag toBag()
    {
        final MutableBooleanBag bag = new BooleanHashBag();
        this.forEach(new BooleanProcedure()
        {
            public void value(boolean each)
            {
                bag.add(each);
            }
        });
        return bag;
    }

    public LazyBooleanIterable asLazy()
    {
        return this;
    }
}
