/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableDoubleListFactory;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;

/**
 * ImmutableDoubleListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableDoubleListFactoryImpl implements ImmutableDoubleListFactory
{
    public ImmutableDoubleList of()
    {
        return this.with();
    }

    public ImmutableDoubleList with()
    {
        return ImmutableDoubleEmptyList.INSTANCE;
    }

    public ImmutableDoubleList of(double one)
    {
        return this.with(one);
    }

    public ImmutableDoubleList with(double one)
    {
        return new ImmutableDoubleSingletonList(one);
    }

    public ImmutableDoubleList of(double... items)
    {
        return this.with(items);
    }

    public ImmutableDoubleList with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayList.newListWith(items);
    }

    public ImmutableDoubleList ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableDoubleList withAll(DoubleIterable items)
    {
        if (items instanceof ImmutableDoubleList)
        {
            return (ImmutableDoubleList) items;
        }
        return this.with(items.toArray());
    }
}
