/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableIntListFactory;
import com.gs.collections.api.list.primitive.ImmutableIntList;

/**
 * ImmutableIntListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableIntListFactoryImpl implements ImmutableIntListFactory
{
    public ImmutableIntList of()
    {
        return this.with();
    }

    public ImmutableIntList with()
    {
        return ImmutableIntEmptyList.INSTANCE;
    }

    public ImmutableIntList of(int one)
    {
        return this.with(one);
    }

    public ImmutableIntList with(int one)
    {
        return new ImmutableIntSingletonList(one);
    }

    public ImmutableIntList of(int... items)
    {
        return this.with(items);
    }

    public ImmutableIntList with(int... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableIntArrayList.newListWith(items);
    }

    public ImmutableIntList ofAll(IntIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableIntList withAll(IntIterable items)
    {
        if (items instanceof ImmutableIntList)
        {
            return (ImmutableIntList) items;
        }
        return this.with(items.toArray());
    }
}
