/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableDoubleBooleanMapFactory;
import com.gs.collections.api.map.primitive.ImmutableDoubleBooleanMap;
import com.gs.collections.api.map.primitive.DoubleBooleanMap;

/**
 * ImmutableDoubleBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleBooleanMapFactoryImpl implements ImmutableDoubleBooleanMapFactory
{
    public ImmutableDoubleBooleanMap of()
    {
        return this.with();
    }

    public ImmutableDoubleBooleanMap with()
    {
        return ImmutableDoubleBooleanEmptyMap.INSTANCE;
    }

    public ImmutableDoubleBooleanMap of(double key, boolean value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleBooleanMap with(double key, boolean value)
    {
        return new ImmutableDoubleBooleanSingletonMap(key, value);
    }

    public ImmutableDoubleBooleanMap ofAll(DoubleBooleanMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleBooleanMap withAll(DoubleBooleanMap map)
    {
        if (map instanceof ImmutableDoubleBooleanMap)
        {
            return (ImmutableDoubleBooleanMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleBooleanSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleBooleanHashMap(map);
    }
}
