/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.FloatByteMap;
import com.gs.collections.api.map.primitive.ImmutableFloatByteMap;
import com.gs.collections.api.map.primitive.MutableFloatByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.FloatBytePair;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatByteProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.map.mutable.primitive.FloatByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

/**
 * ImmutableFloatByteHashMap is the non-modifiable equivalent of {@link FloatByteHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 * @since 4.0.
 */
final class ImmutableFloatByteHashMap implements ImmutableFloatByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatByteMap delegate;

    ImmutableFloatByteHashMap(FloatByteMap delegate)
    {
        this.delegate = new FloatByteHashMap(delegate);
    }

    public byte get(float key)
    {
        return this.delegate.get(key);
    }

    public byte getIfAbsent(float key, byte ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(float key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(byte value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatByteProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.delegate.keysView();
    }

    public RichIterable<FloatBytePair> keyValuesView()
    {
        return this.delegate.keyValuesView();
    }

    public ImmutableFloatByteMap select(FloatBytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatByteMap reject(FloatBytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return ((FloatByteHashMap) this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableFloatByteMap toImmutable()
    {
        return this;
    }

    public ByteIterator byteIterator()
    {
        return this.delegate.byteIterator();
    }

    public void forEach(ByteProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BytePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableByteCollection select(BytePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableByteCollection reject(BytePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public byte max()
    {
        return this.delegate.max();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public byte min()
    {
        return this.delegate.min();
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public byte[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableByteList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public byte[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(byte value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(byte... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ByteIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableByteList toList()
    {
        return this.delegate.toList();
    }

    public MutableByteSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableByteBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyByteIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableFloatByteMap newWithKeyValue(float key, byte value)
    {
        MutableFloatByteMap map = new FloatByteHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatByteMap newWithoutKey(float key)
    {
        MutableFloatByteMap map = new FloatByteHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatByteMap newWithoutAllKeys(FloatIterable keys)
    {
        MutableFloatByteMap map = new FloatByteHashMap(this.size());
        map.putAll(this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableFloatByteMapSerializationProxy(this);
    }

    protected static class ImmutableFloatByteMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private FloatByteMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableFloatByteMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableFloatByteMapSerializationProxy(FloatByteMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedFloatByteProcedure()
                {
                    @Override
                    public void safeValue(float key, byte value) throws IOException
                    {
                        out.writeFloat(key);
                        out.writeByte(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableFloatByteMap deserializedMap = new FloatByteHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readFloat(), in.readByte());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
