/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.factory.map.primitive.ImmutableIntObjectMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntObjectMap;
import com.gs.collections.api.map.primitive.IntObjectMap;

/**
 * ImmutableIntObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntObjectMapFactoryImpl implements ImmutableIntObjectMapFactory
{
    public <V> ImmutableIntObjectMap<V> of()
    {
        return this.with();
    }

    public <V> ImmutableIntObjectMap<V> with()
    {
        return (ImmutableIntObjectMap<V>) ImmutableIntObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableIntObjectMap<V> of(int key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableIntObjectMap<V> with(int key, V value)
    {
        return new ImmutableIntObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableIntObjectMap<V> ofAll(IntObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableIntObjectMap<V> withAll(IntObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableIntObjectMap)
        {
            return (ImmutableIntObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final int[] array = new int[1];
            map.forEachKey(new IntProcedure()
            {
                public void value(int each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableIntObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableIntObjectHashMap<V>(map);
    }
}
